/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.main;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import ucd.pacc.main.ProcessMetaData;
import ucd.pacc.main.ProcessType;
import ucd.pacc.util.ErrorHandler;

public class ProcessNameToIdConvertor {
    private final String processName;
    private final String user;
    private final String url;
    private final String pwd;
    private int processVersion;
    private final ProcessType processType;
    private final ProcessMetaData metaData;

    public ProcessNameToIdConvertor(ProcessMetaData processMetaData, String user, String url, String pwd) {
        this.user = user;
        this.url = url;
        this.pwd = pwd;
        this.processName = processMetaData.getProcessName();
        this.processType = processMetaData.getProcessType();
        this.metaData = processMetaData;
    }

    public String getProcessId() {
        StringBuilder responseBody = this.getProcessDetailsFromServer();
        String processId = this.getProcessIdFromResponseBody(responseBody.toString());
        return processId;
    }

    public int getProcessVersion() {
        return this.processVersion;
    }

    private String getProcessIdFromResponseBody(String responseBody) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(responseBody));
        if (this.processType != ProcessType.GENERIC) {
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject.getString("id");
        }
        JsonArray jsonArray = jsonReader.readArray();
        for (JsonObject jsonObjectNew : jsonArray.getValuesAs(JsonObject.class)) {
            if (!jsonObjectNew.getString("name").equals(this.processName)) continue;
            String processId = jsonObjectNew.getString("id");
            this.processVersion = jsonObjectNew.getInt("version");
            System.out.println("Process id is " + processId);
            return processId;
        }
        ErrorHandler.printErrorAndExit("Unable to determine the process id for process (" + this.processName + ").\nUser can download or make changes to only existing processes");
        throw new RuntimeException("Unable to determine the process id for " + this.processName + " User can make changes to only existing processes");
    }

    private static StringBuilder getResponseBody(CloseableHttpResponse response) {
        try {
            StringBuilder responseBody;
            if (response.getEntity() == null) {
                throw new RuntimeException("Response from the server is null.");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));){
                String line;
                responseBody = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    responseBody.append(line);
                }
            }
            return responseBody;
        }
        catch (IOException e) {
            System.out.println("Unable to read response body.");
            e.printStackTrace();
            throw new RuntimeException("Unable to read response body CloseableHttpResponse.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringBuilder getProcessDetailsFromServer() {
        String urlPre1 = this.getUrlForCommandType();
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.user, this.pwd);
        provider.setCredentials(AuthScope.ANY, (Credentials)creds);
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        try {
            sslContextBuilder.loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultCredentialsProvider((CredentialsProvider)provider).build();){
                HttpGet httpGet = new HttpGet(urlPre1);
                httpGet.addHeader("Content-Type", "text");
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                if (response.getStatusLine().getStatusCode() == 204 || response.getStatusLine().getStatusCode() == 404) {
                    ErrorHandler.printErrorAndExit("The process may not exist for the " + (Object)((Object)this.processType) + ".\nOr Else the Process name or " + (Object)((Object)this.processType) + " name provided is wrong. Please verify");
                }
                if (response.getStatusLine().getStatusCode() < 210) {
                    StringBuilder stringBuilder = ProcessNameToIdConvertor.getResponseBody(response);
                    return stringBuilder;
                }
                throw new RuntimeException(" Unable to get data from server " + response.getStatusLine().getStatusCode());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private String getUrlForCommandType() {
        if (this.processType == ProcessType.GENERIC) {
            return this.getGenericProcessUrl();
        }
        if (this.processType == ProcessType.COMPONENT) {
            return this.getComponentProcessUrl(this.metaData.getParentName());
        }
        if (this.processType == ProcessType.APPLICATION) {
            return this.getApplicationProcessUrl(this.metaData.getParentName());
        }
        throw new RuntimeException("Invalid commandType");
    }

    private String getApplicationProcessUrl(String applicationName) {
        String urlPre1 = this.url + "/cli/applicationProcess/info?application=" + applicationName + "&applicationProcess=" + this.processName;
        return urlPre1;
    }

    private String getComponentProcessUrl(String componentName) {
        String urlPre1 = this.url + "/cli/componentProcess/info?component=" + componentName + "&componentProcess=" + this.processName;
        return urlPre1;
    }

    private String getGenericProcessUrl() {
        String urlPre1 = this.url + "/cli/process";
        return urlPre1;
    }
}

