/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.main;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ScriptInjector {
    public static final String SCRIPT_FILE = "scriptFile";
    public static final String PROPERTIES = "properties";
    public static final String SPACE_AS_HEX = "%20";

    public JSONObject injectScriptFilesIntoProcessDesignJson(JSONObject processSteps) {
        Iterator keys = processSteps.keys();
        JSONObject resultJson = new JSONObject();
        while (keys.hasNext()) {
            String stepName = (String)keys.next();
            try {
                Optional<String> scriptFileNameInPluginStep;
                JSONObject stepJson = (JSONObject)this.getValueFromJson(stepName, processSteps);
                if (this.isStepPluginType(stepJson) && (scriptFileNameInPluginStep = this.getOptionalScriptFile(stepJson)).isPresent() && !scriptFileNameInPluginStep.get().trim().isEmpty()) {
                    StringBuilder scriptBody = this.extractScriptBodyFromFile(scriptFileNameInPluginStep.get());
                    this.updateFileNameInStep(scriptBody, stepJson);
                }
                resultJson.put(stepName, (Object)stepJson);
            }
            catch (JsonProcessingException | JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return resultJson;
    }

    protected void updateFileNameInStep(StringBuilder scriptBody, JSONObject stepJson) throws JSONException {
        JSONObject pluginProperties = (JSONObject)this.getValueFromJson(PROPERTIES, stepJson);
        pluginProperties.put("scriptBody", (Object)scriptBody.toString());
        pluginProperties.remove(SCRIPT_FILE);
        stepJson.put(PROPERTIES, (Object)pluginProperties);
    }

    protected StringBuilder extractScriptBodyFromFile(String scriptFileName) {
        StringBuilder scriptBody = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(scriptFileName));){
            String line;
            while ((line = reader.readLine()) != null) {
                scriptBody.append(line);
                scriptBody.append("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return scriptBody;
    }

    protected Optional<String> getOptionalScriptFile(JSONObject stepJson) throws JSONException, JsonProcessingException {
        JSONObject pluginProperties = (JSONObject)this.getValueFromJson(PROPERTIES, stepJson);
        try {
            String scriptFileName = pluginProperties.getString(SCRIPT_FILE);
            return Optional.of(scriptFileName);
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    protected Optional<Object> getOptionalValueFromJson(String key, JSONObject json) {
        try {
            return Optional.of(this.getValueFromJson(key, json));
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    protected Object getValueFromJson(String key, JSONObject json) throws JSONException {
        Object value = json.get(key);
        return value;
    }

    protected boolean isStepPluginType(JSONObject stepJson) {
        return this.getOptionalValueFromJson("plugin", stepJson).isPresent();
    }

    public String replaceSpaces(String input) {
        if (input == null) {
            return null;
        }
        return input.replace(" ", SPACE_AS_HEX);
    }
}

