/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import java.util.Optional;
import ucd.pacc.model.Stringish;
import ucd.pacc.util.Util;

abstract class StringishImpl
implements Stringish {
    private final String value;

    StringishImpl(String value) {
        this.value = value;
        this.value.getClass();
        Optional<RuntimeException> reason = this.checkValueValidity();
        if (reason.isPresent()) {
            throw reason.get();
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.quote();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().isInstance(obj)) {
            return false;
        }
        return this.getValue().equals(((Stringish)obj).getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    protected int getMinLength() {
        return 0;
    }

    protected int getMaxLength() {
        return Integer.MAX_VALUE;
    }

    protected String getValueName() {
        return this.getClass().getSimpleName();
    }

    protected Optional<RuntimeException> checkValueValidity() {
        return this.checkValueLengthValidity();
    }

    protected Optional<RuntimeException> checkValueLengthValidity() {
        String val = this.getValue();
        if (val.length() < this.getMinLength()) {
            return Optional.of(new IllegalArgumentException(this.getValueName() + " is too short: value=" + Util.quote(this.value)));
        }
        if (val.length() > this.getMaxLength()) {
            return Optional.of(new IllegalArgumentException(this.getValueName() + " is too long: value=" + Util.quote(this.value)));
        }
        return Optional.empty();
    }
}

