/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.decompiler;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Optional;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ScriptExtractor {
    public static final String SCRIPT_BODY = "scriptBody";
    public static final String PROPERTIES = "properties";
    public static final String SPACE_AS_HEX = "%20";
    private final String processName;
    private final String parentName;

    ScriptExtractor(String processName, String parentName) {
        this.processName = processName;
        this.parentName = parentName.isEmpty() ? "Generic" : parentName;
    }

    public JSONObject extractScriptFilesFromProcessDesignJson(JSONObject processSteps) {
        Iterator keys = processSteps.keys();
        JSONObject resultJson = new JSONObject();
        while (keys.hasNext()) {
            String stepName = (String)keys.next();
            try {
                Optional<String> scriptBodyInPluginStep;
                JSONObject stepJson = (JSONObject)this.getValueFromJson(stepName, processSteps);
                if (this.isStepPluginType(stepJson) && (scriptBodyInPluginStep = this.getOptionalScriptBody(stepJson)).isPresent() && !scriptBodyInPluginStep.get().trim().isEmpty()) {
                    this.writeScriptBodyToFile(scriptBodyInPluginStep.get(), stepName);
                    this.updateFileNameInStep(this.getFileName(stepName), stepJson);
                }
                resultJson.put(stepName, (Object)stepJson);
            }
            catch (JsonProcessingException | JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return resultJson;
    }

    protected void updateFileNameInStep(String fileName, JSONObject stepJson) throws JSONException {
        JSONObject pluginProperties = (JSONObject)this.getValueFromJson(PROPERTIES, stepJson);
        pluginProperties.put("scriptFile", (Object)fileName);
        pluginProperties.remove(SCRIPT_BODY);
        stepJson.put(PROPERTIES, (Object)pluginProperties);
    }

    protected void writeScriptBodyToFile(String scriptBody, String stepName) {
        String fileName = this.getFileName(stepName);
        try (BufferedReader reader = new BufferedReader(new StringReader(scriptBody));
             FileWriter out = new FileWriter(fileName);){
            String line;
            while ((line = reader.readLine()) != null) {
                out.write(line);
                out.write("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getFileName(String stepName) {
        return this.replaceSpaces(this.parentName) + "-" + this.replaceSpaces(this.processName) + "-" + this.replaceSpaces(stepName) + ".txt";
    }

    protected Optional<String> getOptionalScriptBody(JSONObject stepJson) throws JSONException, JsonProcessingException {
        JSONObject pluginProperties = (JSONObject)this.getValueFromJson(PROPERTIES, stepJson);
        try {
            String scriptBody = pluginProperties.getString(SCRIPT_BODY);
            return Optional.of(scriptBody);
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    private Optional<Object> getOptionalValueFromJson(String key, JSONObject json) {
        try {
            return Optional.of(this.getValueFromJson(key, json));
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    private Object getValueFromJson(String key, JSONObject json) throws JSONException {
        Object value = json.get(key);
        return value;
    }

    protected boolean isStepPluginType(JSONObject stepJson) {
        return this.getOptionalValueFromJson("plugin", stepJson).isPresent();
    }

    public String replaceSpaces(String input) {
        if (input == null) {
            return null;
        }
        return input.replace(" ", SPACE_AS_HEX);
    }
}

