/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.decompiler;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.decompiler.DefaultValueSelector;
import ucd.pacc.decompiler.SelectPropertyValueWithSelectedFlag;
import ucd.pacc.model.AbstractManualTaskStep;
import ucd.pacc.model.AcquireLockStep;
import ucd.pacc.model.ActionGroup;
import ucd.pacc.model.ActionGroupStep;
import ucd.pacc.model.ActionsOnEvent;
import ucd.pacc.model.AddInventoryStatusStep;
import ucd.pacc.model.AddProcessWarningStep;
import ucd.pacc.model.AnyUserTaskApprovalRestriction;
import ucd.pacc.model.AppProcessResourceStep;
import ucd.pacc.model.AppProcessStep;
import ucd.pacc.model.AppRemovalProcessStep;
import ucd.pacc.model.ApplicationRunComponentProcessStep;
import ucd.pacc.model.CheckboxPropertyDefinitionOptions;
import ucd.pacc.model.CommonPropertyDefinitionOptions;
import ucd.pacc.model.ComponentRunComponentProcessStep;
import ucd.pacc.model.ComponentStep;
import ucd.pacc.model.DateTimePropertyDefinitionOptions;
import ucd.pacc.model.DeployingUserTaskApprovalRestriction;
import ucd.pacc.model.FinishStep;
import ucd.pacc.model.ForEachAgentStep;
import ucd.pacc.model.ForEachResourceTagStep;
import ucd.pacc.model.GenericManualTaskStep;
import ucd.pacc.model.IdentityBasedTaskApprovalRestriction;
import ucd.pacc.model.InventoryStep;
import ucd.pacc.model.JoinStep;
import ucd.pacc.model.MultiComponentStep;
import ucd.pacc.model.MultiSelectPropertyDefinitionOptions;
import ucd.pacc.model.MultiValuedPropertyDefinitionOptions;
import ucd.pacc.model.PluginStep;
import ucd.pacc.model.PropertyContainer;
import ucd.pacc.model.PropertyDefinition;
import ucd.pacc.model.PropertyDefinitionOptions;
import ucd.pacc.model.ReleaseLockStep;
import ucd.pacc.model.RemoveInventoryStatusStep;
import ucd.pacc.model.ResourceStep;
import ucd.pacc.model.ResourceTagName;
import ucd.pacc.model.RoleBasedTaskApprovalRestriction;
import ucd.pacc.model.RoleRestriction;
import ucd.pacc.model.RunGenericProcessStep;
import ucd.pacc.model.RunOnFirstOnlineResourceOnlyStep;
import ucd.pacc.model.RunOperationalProcessForMultipleComponentsStep;
import ucd.pacc.model.SecurePropertyDefinitionOptions;
import ucd.pacc.model.SelectPropertyDefinitionOptions;
import ucd.pacc.model.SetFinalProcessStatusStep;
import ucd.pacc.model.StartStep;
import ucd.pacc.model.Step;
import ucd.pacc.model.StepAction;
import ucd.pacc.model.StepActionFinish;
import ucd.pacc.model.StepActionStart;
import ucd.pacc.model.Stringish;
import ucd.pacc.model.SwitchStep;
import ucd.pacc.model.TaskApprovalRestriction;
import ucd.pacc.model.TextAreaPropertyDefinitionOptions;
import ucd.pacc.model.TextPropertyDefinitionOptions;
import ucd.pacc.parser.ParseException;
import ucd.pacc.util.StepGraphProcessor;
import ucd.pacc.util.Util;

class UcdToUserJsonConvertor
extends StepGraphProcessor<UcdToUserJsonConvertor> {
    private JSONObject nestedProcessInForEachJson;
    private final JSONObject rootJson = new JSONObject();
    boolean inNestedContainer = false;
    private JSONObject forEachStepJson;

    UcdToUserJsonConvertor() {
    }

    public JSONObject getProcessJson() {
        this.checkExecuted();
        return this.rootJson;
    }

    @Override
    protected void processStep(Step step) throws ParseException {
        if (step instanceof ForEachResourceTagStep) {
            this.processForEachResourceTagStep((ForEachResourceTagStep)step);
        } else if (step instanceof ForEachAgentStep) {
            this.processForEachAgentStep((ForEachAgentStep)step);
        } else if (step instanceof PluginStep) {
            this.processPluginStep((PluginStep)step);
        } else if (step instanceof AcquireLockStep) {
            this.processAcquireLockStep((AcquireLockStep)step);
        } else if (step instanceof ReleaseLockStep) {
            this.processReleaseLockStep((ReleaseLockStep)step);
        } else if (step instanceof SetFinalProcessStatusStep) {
            this.processSetFinalStatusStep((SetFinalProcessStatusStep)step);
        } else if (step instanceof AddInventoryStatusStep) {
            this.processAddInventoryStatusStep((AddInventoryStatusStep)step);
        } else if (step instanceof RemoveInventoryStatusStep) {
            this.processRemoveInventoryStatusStep((RemoveInventoryStatusStep)step);
        } else if (step instanceof AddProcessWarningStep) {
            this.processAddProcessWarningStep((AddProcessWarningStep)step);
        } else if (step instanceof RunGenericProcessStep) {
            this.processRunGenericProcessStep((RunGenericProcessStep)step);
        } else if (step instanceof ComponentRunComponentProcessStep) {
            this.processComponentRunComponentProcessStep((ComponentRunComponentProcessStep)step);
        } else if (step instanceof GenericManualTaskStep) {
            this.processGenericManualTaskStep((GenericManualTaskStep)step);
        } else if (step instanceof AbstractManualTaskStep) {
            this.processAbstractManualTaskStep((AbstractManualTaskStep)step);
        } else if (step instanceof SwitchStep) {
            this.processSwitchStep((SwitchStep)step);
        } else if (step instanceof JoinStep) {
            this.processJoinStep((JoinStep)step);
        } else if (step instanceof FinishStep) {
            this.processFinishStep((FinishStep)step);
        } else if (step instanceof StartStep) {
            this.processStartStep((StartStep)step);
        } else if (step instanceof AppProcessStep) {
            this.processAppProcessStep((AppProcessStep)step);
        } else {
            throw new RuntimeException("unimplemented step: " + step.getClass().getName());
        }
    }

    @Override
    protected UcdToUserJsonConvertor createNestedInstance() throws ParseException {
        return this;
    }

    @Override
    protected void processStepStart(Step step) throws ParseException {
        if (step instanceof ForEachResourceTagStep) {
            this.processForEachResourceTagStepStart((ForEachResourceTagStep)step);
        } else if (step instanceof ForEachAgentStep) {
            this.processForEachAgentStepStart((ForEachAgentStep)step);
        }
    }

    @Override
    protected void processStepEnd(Step step) throws ParseException {
        if (step instanceof ForEachResourceTagStep) {
            this.processForEachResourceTagStepEnd((ForEachResourceTagStep)step);
        } else if (step instanceof ForEachAgentStep) {
            this.processForEachAgentStepEnd((ForEachAgentStep)step);
        }
    }

    protected void processForEachResourceTagStepStart(ForEachResourceTagStep step) {
        this.forEachStepJson = new JSONObject();
        this.appendStepStart(step, this.forEachStepJson);
        this.appendStepType(step, this.forEachStepJson);
        this.nestedProcessInForEachJson = new JSONObject();
        this.addKeyValueToJson("child-process", this.nestedProcessInForEachJson, this.forEachStepJson);
        this.inNestedContainer = true;
        JSONArray jsonArray = new JSONArray();
        for (ResourceTagName tag : step.getTags()) {
            jsonArray.put((Object)tag.escape());
        }
        this.addKeyValueToJson("tag", jsonArray, this.forEachStepJson);
        this.addKeyValueToJson("max-concurrent-tags", step.getMaxConcurrentTags().getValue(), this.forEachStepJson);
    }

    protected void processForEachResourceTagStepEnd(ForEachResourceTagStep step) {
        this.appendActionGroup(step, this.forEachStepJson);
        this.inNestedContainer = false;
    }

    protected void processForEachAgentStepStart(ForEachAgentStep step) {
        this.forEachStepJson = new JSONObject();
        this.appendStepStart(step, this.forEachStepJson);
        this.appendStepType(step, this.forEachStepJson);
        this.nestedProcessInForEachJson = new JSONObject();
        this.addKeyValueToJson("child-process", this.nestedProcessInForEachJson, this.forEachStepJson);
        this.inNestedContainer = true;
        JSONArray jsonArray = new JSONArray();
        for (ResourceTagName tag : step.getTags()) {
            jsonArray.put((Object)tag);
        }
        this.addKeyValueToJson("tag", jsonArray, this.forEachStepJson);
        this.addKeyValueToJson("max-concurrent-agents", step.getMaxConcurrentAgents().getValue(), this.forEachStepJson);
    }

    protected void processForEachAgentStepEnd(ForEachAgentStep step) {
        this.appendActionGroup(step, this.forEachStepJson);
        this.inNestedContainer = false;
    }

    protected void processAppProcessStep(AppProcessStep step) {
        AppProcessResourceStep procStep;
        MultiComponentStep multiStep;
        JSONObject stepJson = new JSONObject();
        this.appendStepStart(step, stepJson);
        this.appendStepType(step, stepJson);
        if (step instanceof ComponentStep) {
            ComponentStep componentStep = (ComponentStep)((Object)step);
            this.addKeyValueToJson("component", componentStep.getComponent().escape(), stepJson);
        }
        this.addKeyValueToJson("process", step.getProcess().escape(), stepJson);
        if (step instanceof AppRemovalProcessStep) {
            AppRemovalProcessStep removalStep = (AppRemovalProcessStep)((Object)step);
            this.addKeyValueToJson(removalStep.getPacRemovalTypeKeyword(), removalStep.getRemovalType().getPacKeyword(), stepJson);
        }
        if (step instanceof InventoryStep) {
            InventoryStep inventoryStep = (InventoryStep)((Object)step);
            this.addKeyValueToJson(inventoryStep.getPacTargetInventoryStatusKeyword(), inventoryStep.getTargetInventoryStatus().escape(), stepJson);
        }
        if (step instanceof MultiComponentStep) {
            multiStep = (MultiComponentStep)((Object)step);
            multiStep.getByComponentTag().ifPresent(tag -> this.addKeyValueToJson("select-components-by-tag", tag.escape(), stepJson));
        }
        if (step instanceof ResourceStep) {
            ResourceStep resourceStep = (ResourceStep)((Object)step);
            resourceStep.getByResourceTag().ifPresent(tag -> this.addKeyValueToJson("select-resources-by-tag", tag.escape(), stepJson));
        }
        if (step instanceof ApplicationRunComponentProcessStep) {
            procStep = (ApplicationRunComponentProcessStep)step;
            ((ApplicationRunComponentProcessStep)procStep).getByChangedComponent().ifPresent(changes -> {
                JSONObject componentSelectionCriteria = new JSONObject();
                this.addKeyValueToJson("select-resources-by-changed-component-list", componentSelectionCriteria, stepJson);
                JSONArray components = new JSONArray();
                changes.getComponents().stream().map(Stringish::escape).forEach(arg_0 -> ((JSONArray)components).put(arg_0));
                this.addKeyValueToJson("components", components, componentSelectionCriteria);
                this.addKeyValueToJson("select-resources", changes.getMode().getPacKeyword(), componentSelectionCriteria);
            });
        }
        if (step instanceof RunOperationalProcessForMultipleComponentsStep) {
            procStep = (RunOperationalProcessForMultipleComponentsStep)step;
            ((RunOperationalProcessForMultipleComponentsStep)procStep).getByChangedComponent().ifPresent(changes -> {
                JSONObject componentResourceTagSelectionCriteria = new JSONObject();
                this.addKeyValueToJson("select-resources-by-changed-component-tag", componentResourceTagSelectionCriteria, stepJson);
                changes.getByComponentTag().ifPresent(tag -> this.addKeyValueToJson("select-components-by-tag", tag.escape(), componentResourceTagSelectionCriteria));
                this.addKeyValueToJson("select-resources", changes.getMode().getPacKeyword(), componentResourceTagSelectionCriteria);
            });
        }
        this.addKeyValueToJson("fail-fast", step.isFailFast(), stepJson);
        this.addKeyValueToJson("ignore-child-warnings", step.isIgnoreChildWarnings(), stepJson);
        if (step instanceof RunOnFirstOnlineResourceOnlyStep) {
            RunOnFirstOnlineResourceOnlyStep firstOnlineStep = (RunOnFirstOnlineResourceOnlyStep)((Object)step);
            this.addKeyValueToJson("run-on-first-online-resource-only", firstOnlineStep.isRunOnFirstOnlineResourceOnly(), stepJson);
        }
        this.addKeyValueToJson("max-concurrent-processes", step.getMaxConcurrentProcesses().getValue(), stepJson);
        if (step instanceof MultiComponentStep) {
            multiStep = (MultiComponentStep)((Object)step);
            this.addKeyValueToJson("max-concurrent-components", multiStep.getMaxConcurrentComponents().getValue(), stepJson);
        }
        step.getPreconditionScript().ifPresent(script -> this.addKeyValueToJson("precondition-script", script, stepJson));
        if (step instanceof PropertyContainer) {
            this.appendProperties((PropertyContainer)((Object)step), stepJson);
        }
        this.appendActionGroup(step, stepJson);
    }

    private void appendStepType(Step step, JSONObject stepJson) {
        try {
            stepJson.put("type", (Object)step.getPacStepKeyword());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processPluginStep(PluginStep step) {
        JSONObject stepJson = new JSONObject();
        this.appendStepStart(step, stepJson);
        this.appendStepType(step, stepJson);
        this.addKeyValueToJson("plugin", step.getPlugin().escape(), stepJson);
        this.addKeyValueToJson("command", step.getCommand().escape(), stepJson);
        step.getWorkingDirectory().ifPresent(dir -> this.addKeyValueToJson("working-directory", dir.escape(), stepJson));
        step.getPreconditionScript().ifPresent(script -> this.addKeyValueToJson("precondition-script", script.escape(), stepJson));
        this.appendProperties(step, stepJson);
        this.appendActionGroup(step, stepJson);
    }

    protected void processAcquireLockStep(AcquireLockStep step) {
        JSONObject stepJson = new JSONObject();
        this.appendStepStart(step, stepJson);
        this.addKeyValueToJson("type", "acquire-lock", stepJson);
        this.addKeyValueToJson("lock", step.getLock().escape(), stepJson);
        this.appendActionGroup(step, stepJson);
    }

    protected void processReleaseLockStep(ReleaseLockStep step) {
        JSONObject stepJson = new JSONObject();
        this.appendStepStart(step, stepJson);
        this.addKeyValueToJson("type", "release-lock", stepJson);
        this.addKeyValueToJson("lock", step.getLock().escape(), stepJson);
        this.appendActionGroup(step, stepJson);
    }

    protected void processSetFinalStatusStep(SetFinalProcessStatusStep step) {
        JSONObject stepJson = new JSONObject();
        this.appendStepStart(step, stepJson);
        this.appendStepType(step, stepJson);
        this.addKeyValueToJson("status", step.getStatus().getPacKeyword(), stepJson);
        this.appendActionGroup(step, stepJson);
    }

    protected void processAddInventoryStatusStep(AddInventoryStatusStep step) {
        JSONObject stepJson = new JSONObject();
        this.appendStepStart(step, stepJson);
        this.appendStepType(step, stepJson);
        this.addKeyValueToJson("status", step.getStatus().escape(), stepJson);
        this.appendActionGroup(step, stepJson);
    }

    protected void processRemoveInventoryStatusStep(RemoveInventoryStatusStep step) {
        JSONObject stepJson = new JSONObject();
        this.appendStepStart(step, stepJson);
        this.appendStepType(step, stepJson);
        this.addKeyValueToJson("status", step.getStatus().escape(), stepJson);
        this.appendActionGroup(step, stepJson);
    }

    protected void processAddProcessWarningStep(AddProcessWarningStep step) {
        JSONObject stepJson = new JSONObject();
        this.appendStepStart(step, stepJson);
        this.appendStepType(step, stepJson);
        this.addKeyValueToJson("message", step.getWarning().escape(), stepJson);
        this.appendActionGroup(step, stepJson);
    }

    protected void processRunGenericProcessStep(RunGenericProcessStep step) {
        JSONObject stepJson = new JSONObject();
        this.appendStepStart(step, stepJson);
        this.appendStepType(step, stepJson);
        this.addKeyValueToJson("process", step.getProcess().escape(), stepJson);
        step.getResourcePath().ifPresent(path -> this.addKeyValueToJson("resource-path", path.escape(), stepJson));
        this.addKeyValueToJson("ignore-child-warnings", step.isIgnoreChildWarnings(), stepJson);
        this.appendProperties(step, stepJson);
        this.appendActionGroup(step, stepJson);
    }

    protected void processComponentRunComponentProcessStep(ComponentRunComponentProcessStep step) {
        JSONObject stepJson = new JSONObject();
        this.appendStepStart(step, stepJson);
        this.appendStepType(step, stepJson);
        this.addKeyValueToJson("process", step.getProcess().escape(), stepJson);
        this.appendProperties(step, stepJson);
        this.appendActionGroup(step, stepJson);
    }

    protected void processSwitchStep(SwitchStep step) {
        JSONObject stepJson = new JSONObject();
        this.appendStepStart(step, stepJson);
        this.appendStepType(step, stepJson);
        this.addKeyValueToJson("evaluate", step.getExpression().escape(), stepJson);
        JSONObject switchCases = new JSONObject();
        this.addKeyValueToJson("case", switchCases, stepJson);
        for (SwitchStep.SwitchStepMatchCase kase2 : step.getMatchCases()) {
            JSONObject eventJson = new JSONObject();
            this.appendStepActions(kase2.getActions(), eventJson);
            this.addKeyValueToJson(kase2.getMatch().getValue(), eventJson, switchCases);
        }
        step.getDefaultCase().ifPresent(kase -> {
            JSONObject eventJson = new JSONObject();
            this.appendStepActions(kase.getActions(), eventJson);
            this.addKeyValueToJson("DEFAULT", eventJson, switchCases);
        });
    }

    protected void processGenericManualTaskStep(GenericManualTaskStep step) {
        JSONObject stepJson = new JSONObject();
        this.appendStepStart(step, stepJson);
        this.appendStepType(step, stepJson);
        this.processGenericProcessTaskApprovalRestriction(step.getApprovalRestriction(), stepJson);
        step.getNotificationTemplate().ifPresent(template -> this.addKeyValueToJson("notification-template", template.escape(), stepJson));
        this.addKeyValueToJson("comment-required", step.isCommentRequired(), stepJson);
        step.getCommentPrompt().ifPresent(prompt -> this.addKeyValueToJson("comment-prompt", prompt.escape(), stepJson));
        if (!step.getPropertyDefinitions().isEmpty()) {
            JSONArray propDefinitionArray = new JSONArray();
            this.addKeyValueToJson("property-definition", propDefinitionArray, stepJson);
            step.getPropertyDefinitions().forEach(propDef -> this.processPropertyDefinition((PropertyDefinition)propDef, propDefinitionArray));
        }
        this.appendActionGroup(step, stepJson);
    }

    protected void processAbstractManualTaskStep(AbstractManualTaskStep step) {
        JSONObject stepJson = new JSONObject();
        this.appendStepStart(step, stepJson);
        this.appendStepType(step, stepJson);
        this.processTaskApprovalRestriction0(step.getApprovalRestriction(), stepJson);
        step.getNotificationTemplate().ifPresent(template -> this.addKeyValueToJson("notification-template", template.escape(), stepJson));
        if (!step.getPropertyDefinitions().isEmpty()) {
            JSONArray propDefinitionArray = new JSONArray();
            this.addKeyValueToJson("property-definition", propDefinitionArray, stepJson);
            step.getPropertyDefinitions().forEach(propDef -> this.processPropertyDefinition((PropertyDefinition)propDef, propDefinitionArray));
        }
        this.appendActionGroup(step, stepJson);
    }

    private void processTaskApprovalRestriction0(TaskApprovalRestriction approvalRestriction, JSONObject stepJson) {
        JSONObject roleRestrictionData = new JSONObject();
        if (approvalRestriction instanceof AnyUserTaskApprovalRestriction) {
            this.addKeyValueToJson("deployingUserOnly", false, stepJson);
            this.addKeyValueToJson("roleRestrictions", new JSONArray(), roleRestrictionData);
        } else if (approvalRestriction instanceof DeployingUserTaskApprovalRestriction) {
            this.addKeyValueToJson("deployingUserOnly", true, stepJson);
            this.addKeyValueToJson("roleRestrictions", new JSONArray(), roleRestrictionData);
        } else if (!(approvalRestriction instanceof IdentityBasedTaskApprovalRestriction) && approvalRestriction instanceof RoleBasedTaskApprovalRestriction) {
            RoleBasedTaskApprovalRestriction roleBaseApprovalRestriction = (RoleBasedTaskApprovalRestriction)approvalRestriction;
            this.addKeyValueToJson("contextType", roleBaseApprovalRestriction.getJsonKeyword(), roleRestrictionData);
            JSONArray roleRestrictions = new JSONArray();
            roleBaseApprovalRestriction.getRestrictions().forEach(restriction -> roleRestrictions.put((Object)restriction.getRole().getValue()));
            this.addKeyValueToJson("roleRestrictions", roleRestrictions, roleRestrictionData);
            this.addKeyValueToJson("deployingUserOnly", false, stepJson);
        }
        this.addKeyValueToJson("roleRestrictionData", roleRestrictionData, stepJson);
    }

    protected void processGenericProcessTaskApprovalRestriction(TaskApprovalRestriction approvalRestriction, JSONObject stepJson) {
        JSONObject restrictionJson = new JSONObject();
        if (approvalRestriction instanceof DeployingUserTaskApprovalRestriction) {
            this.addKeyValueToJson("deploying-user", "", restrictionJson);
        } else if (approvalRestriction instanceof IdentityBasedTaskApprovalRestriction) {
            IdentityBasedTaskApprovalRestriction identityBasedApprovalRestriction = (IdentityBasedTaskApprovalRestriction)approvalRestriction;
            JSONObject identitiesJson = new JSONObject();
            this.addKeyValueToJson("identities", identitiesJson, restrictionJson);
            this.processIdentityList(identityBasedApprovalRestriction.getUsers(), "users", identitiesJson);
            this.processIdentityList(identityBasedApprovalRestriction.getGroups(), "groups", identitiesJson);
        } else {
            throw new RuntimeException("unimplemented restriction type: " + approvalRestriction.getClass().getName());
        }
        this.addKeyValueToJson("restrict-approval-to", restrictionJson, stepJson);
    }

    protected void processIdentityList(List<? extends Stringish> identities, String restrictionCandidate, JSONObject jsonObject) {
        restrictionCandidate.getClass();
        JSONArray jsonArray = new JSONArray();
        if (!identities.isEmpty()) {
            identities.forEach(identity -> jsonArray.put((Object)identity.escape()));
        }
        this.addKeyValueToJson(restrictionCandidate, jsonArray, jsonObject);
    }

    protected void processRoleRestriction(RoleRestriction restriction, JSONObject jsonObject) {
        Util.ifPresentOrElse(restriction.getResourceType(), type -> this.addKeyValueToJson("role", restriction.getRole().escape(), jsonObject), () -> this.addKeyValueToJson("role", restriction.getRole().escape(), jsonObject));
    }

    protected void processPropertyDefinition(PropertyDefinition propdef, JSONArray jsonArray) {
        JSONObject propJson = new JSONObject();
        jsonArray.put((Object)propJson);
        if (!propdef.getOptions().isPresent()) {
            this.addKeyValueToJson(propdef.getName().getValue(), propdef.getPacKeyword(), propJson);
        } else {
            this.addKeyValueToJson("property-name", propdef.getName().escape(), propJson);
            this.addKeyValueToJson("property-type", propdef.getPacKeyword(), propJson);
            PropertyDefinitionOptions options = propdef.getOptions().get();
            switch (propdef.getType()) {
                case TEXT: {
                    this.processTextPropertyDefinitionOptions(propdef, (TextPropertyDefinitionOptions)options, propJson);
                    break;
                }
                case TEXT_AREA: {
                    this.processTextAreaPropertyDefinitionOptions(propdef, (TextAreaPropertyDefinitionOptions)options, propJson);
                    break;
                }
                case SECURE: {
                    this.processSecurePropertyDefinitionOptions(propdef, (SecurePropertyDefinitionOptions)options, propJson);
                    break;
                }
                case CHECKBOX: {
                    this.processCheckboxPropertyDefinitionOptions(propdef, (CheckboxPropertyDefinitionOptions)options, propJson);
                    break;
                }
                case DATE_TIME: {
                    this.processDateTimePropertyDefinitionOptions(propdef, (DateTimePropertyDefinitionOptions)options, propJson);
                    break;
                }
                case MULTI_SELECT: {
                    this.processMultiSelectPropertyDefinitionOptions(propdef, (MultiSelectPropertyDefinitionOptions)options, propJson);
                    break;
                }
                case SELECT: {
                    this.processSelectPropertyDefinitionOptions(propdef, (SelectPropertyDefinitionOptions)options, propJson);
                    break;
                }
                default: {
                    throw new RuntimeException("unimplemented propdef type: " + propdef.getType());
                }
            }
        }
    }

    protected void processTextPropertyDefinitionOptions(PropertyDefinition propdef, TextPropertyDefinitionOptions options, JSONObject propJson) {
        options.getCommonOptions().ifPresent(option -> this.processCommonPropertyDefinitionOptions((CommonPropertyDefinitionOptions)option, propJson));
        options.getDefaultValue().ifPresent(value -> this.addKeyValueToJson("default", value.escape(), propJson));
    }

    protected void processTextAreaPropertyDefinitionOptions(PropertyDefinition propdef, TextAreaPropertyDefinitionOptions options, JSONObject propJson) {
        options.getCommonOptions().ifPresent(option -> this.processCommonPropertyDefinitionOptions((CommonPropertyDefinitionOptions)option, propJson));
        options.getDefaultValue().ifPresent(value -> this.addKeyValueToJson("default", value.escape(), propJson));
    }

    protected void processSecurePropertyDefinitionOptions(PropertyDefinition propdef, SecurePropertyDefinitionOptions options, JSONObject propJson) {
        options.getCommonOptions().ifPresent(option -> this.processSecurePropertyDefinitionOptions((CommonPropertyDefinitionOptions)option, propJson));
        options.getDefaultValue().ifPresent(value -> this.addKeyValueToJson("default", value.escape(), propJson));
    }

    protected void processCheckboxPropertyDefinitionOptions(PropertyDefinition propdef, CheckboxPropertyDefinitionOptions options, JSONObject propJson) {
        options.getCommonOptions().ifPresent(option -> this.processCommonPropertyDefinitionOptions((CommonPropertyDefinitionOptions)option, propJson));
        this.addKeyValueToJson("default", options.getDefaultValue(), propJson);
    }

    protected void processDateTimePropertyDefinitionOptions(PropertyDefinition propdef, DateTimePropertyDefinitionOptions options, JSONObject propJson) {
        options.getCommonOptions().ifPresent(option -> this.processCommonPropertyDefinitionOptions((CommonPropertyDefinitionOptions)option, propJson));
        options.getDefaultValue().ifPresent(value -> this.addKeyValueToJson("default", this.getReadableDateTimeFromEpoch((Instant)value), propJson));
    }

    protected String getReadableDateTimeFromEpoch(Instant instant) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
        return dateTime.format(formatter);
    }

    protected void processSelectPropertyDefinitionOptions(PropertyDefinition propdef, SelectPropertyDefinitionOptions options, JSONObject propJson) {
        DefaultValueSelector selector = new DefaultValueSelector(options.getDefaultValue());
        this.processMultiValuedPropertyDefinitionOptions(options, selector, propJson);
    }

    protected void processMultiSelectPropertyDefinitionOptions(PropertyDefinition propdef, MultiSelectPropertyDefinitionOptions options, JSONObject propJson) {
        DefaultValueSelector selector = new DefaultValueSelector(options.getDefaultValues());
        this.processMultiValuedPropertyDefinitionOptions(options, selector, propJson);
    }

    protected void processMultiValuedPropertyDefinitionOptions(MultiValuedPropertyDefinitionOptions options, DefaultValueSelector selector, JSONObject propJson) {
        JSONArray jsonArray = new JSONArray();
        this.addKeyValueToJson("values", jsonArray, propJson);
        options.getValues().stream().map(SelectPropertyValueWithSelectedFlag::new).map(selector::selectIfDefault).forEach(value -> {
            JSONObject multiValueJson = new JSONObject();
            jsonArray.put((Object)multiValueJson);
            this.processSelectPropertyValueWithSelectedFlag((SelectPropertyValueWithSelectedFlag)value, multiValueJson);
        });
        options.getCommonOptions().ifPresent(commons -> this.processCommonPropertyDefinitionOptions((CommonPropertyDefinitionOptions)commons, propJson));
    }

    protected void processSelectPropertyValueWithSelectedFlag(SelectPropertyValueWithSelectedFlag value, JSONObject propJson) {
        boolean hasLabel = value.getLabel().isPresent();
        boolean isSelected = value.isSelected();
        if (hasLabel) {
            this.addKeyValueToJson("label", value.getLabel().get().escape(), propJson);
        }
        if (isSelected) {
            this.addKeyValueToJson("selected", true, propJson);
        }
        this.addKeyValueToJson("value", value.getValue().escape(), propJson);
    }

    protected void processCommonPropertyDefinitionOptions(CommonPropertyDefinitionOptions options, JSONObject propJson) {
        options.getLabel().ifPresent(label -> this.addKeyValueToJson("label", label.escape(), propJson));
        options.getDescription().ifPresent(description -> this.addKeyValueToJson("description", description.escape(), propJson));
        options.getPattern().ifPresent(pattern -> this.addKeyValueToJson("pattern", pattern.escape(), propJson));
        if (options.isRequired()) {
            this.addKeyValueToJson("required", options.isRequired(), propJson);
        }
    }

    protected void processSecurePropertyDefinitionOptions(CommonPropertyDefinitionOptions options, JSONObject propJson) {
        options.getLabel().ifPresent(label -> this.addKeyValueToJson("label", label.escape(), propJson));
        options.getDescription().ifPresent(description -> this.addKeyValueToJson("description", description.escape(), propJson));
        if (options.isRequired()) {
            this.addKeyValueToJson("required", options.isRequired(), propJson);
        }
    }

    protected void processJoinStep(JoinStep step) {
        JSONObject stepJson = new JSONObject();
        this.appendStepStart(step, stepJson);
        this.appendStepType(step, stepJson);
        JSONObject events = new JSONObject();
        this.addKeyValueToJson("on", events, stepJson);
        this.appendStepActions(step.getActions(), events);
    }

    protected void processStartStep(StartStep step) {
        JSONObject stepJson = new JSONObject();
        this.appendStepStart(step, stepJson);
        this.appendStepType(step, stepJson);
        this.appendStepActions(step.getActions(), stepJson);
    }

    protected void processForEachResourceTagStep(ForEachResourceTagStep step) {
    }

    protected void processForEachAgentStep(ForEachAgentStep step) {
    }

    protected void processFinishStep(FinishStep step) {
    }

    protected void appendProperties(PropertyContainer container, JSONObject stepJson) {
        JSONObject propertyJson = new JSONObject();
        try {
            stepJson.put("properties", (Object)propertyJson);
            container.getProperties().forEach(property -> this.addKeyValueToJson(property.getName().escape(), property.getExpression().getValue(), propertyJson));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected void appendStepStart(Step step, JSONObject stepJson) {
        String stepName;
        String string = stepName = step.getPacStepKeyword().equals("start") ? "start" : step.getName().escape();
        if (this.inNestedContainer) {
            this.addKeyValueToJson(stepName, stepJson, this.nestedProcessInForEachJson);
        } else {
            this.addKeyValueToJson(stepName, stepJson, this.rootJson);
        }
    }

    protected void appendActionGroup(ActionGroupStep step, JSONObject stepJson) {
        ActionGroup group = step.getActionGroup();
        JSONObject nextStepsJson = new JSONObject();
        try {
            stepJson.put("on", (Object)nextStepsJson);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        group.getActionsOnSuccess().ifPresent(actions -> this.appendActions((ActionsOnEvent)actions, nextStepsJson));
        group.getActionsOnFailure().ifPresent(actions -> this.appendActions((ActionsOnEvent)actions, nextStepsJson));
        group.getActionsOnComplete().ifPresent(actions -> this.appendActions((ActionsOnEvent)actions, nextStepsJson));
    }

    protected void appendActions(ActionsOnEvent actions, JSONObject nextStepsJson) {
        JSONObject nextStepConditionsJson = new JSONObject();
        try {
            nextStepsJson.put(actions.getEvent().getPacKeyword(), (Object)nextStepConditionsJson);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        this.appendStepActions(actions.getActions(), nextStepConditionsJson);
    }

    protected void appendStepActions(List<StepAction> stepActions, JSONObject eventJson) {
        JSONArray startSteps = new JSONArray();
        for (StepAction action : stepActions) {
            if (action instanceof StepActionFinish) {
                this.addKeyValueToJson("finish", "", eventJson);
                continue;
            }
            if (action instanceof StepActionStart) {
                startSteps.put((Object)action.getTarget().escape());
                continue;
            }
            throw new RuntimeException("unimplemented action: " + action.getClass().getName());
        }
        if (startSteps.length() > 0) {
            this.addKeyValueToJson("start", startSteps, eventJson);
        }
    }

    protected void addKeyValueToJson(String key, Object value, JSONObject json) {
        try {
            json.put(key, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

