/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.json;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonObject;
import ucd.pacc.model.AppMultiComponentInventoryStep;
import ucd.pacc.model.AppMultiComponentStep;
import ucd.pacc.model.InventoryStatusName;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.Property;
import ucd.pacc.model.RemovalType;
import ucd.pacc.model.ResourceTagName;
import ucd.pacc.model.StepName;
import ucd.pacc.parser.json.StepExtractor;
import ucd.pacc.parser.json.StepExtractorAppProcess;
import ucd.pacc.util.JsonUtil;
import ucd.pacc.util.Util;

abstract class StepExtractorAppMultiComponent<T extends AppMultiComponentInventoryStep>
extends StepExtractorAppProcess<T> {
    private final String versionIterator;

    StepExtractorAppMultiComponent(ParseSourcePosition position, JsonObject object, String context, JsonUtil jsonUtil, String versionIterator) {
        super(position, object, context, jsonUtil);
        this.versionIterator = versionIterator;
        this.versionIterator.getClass();
    }

    @Override
    protected void configureStep(T step) {
        super.configureStep(step);
        ((AppMultiComponentStep)step).setByComponentTag(this.getByComponentTag());
        this.getMaxConcurrentComponents().ifPresent(arg_0 -> step.setMaxConcurrentComponents(arg_0));
    }

    @Override
    protected StepName getStepName() {
        return this.parse(StepName::new, this.mustFindString(new StepExtractor.JsonKey("name"), new StepExtractor.JsonPath("$.children[?(@.type == 'componentEnvironmentIterator')].children[?(@.type == '" + this.versionIterator + "')].children[?(@.type == 'componentProcess')]")));
    }

    @Override
    protected Optional<ResourceTagName> getByResourceTag() {
        return this.findString(new StepExtractor.JsonKey("tagId"), new StepExtractor.JsonPath("$.children[?(@.type == 'componentEnvironmentIterator')]")).filter(Util::isNotEmpty).map(this.createParser(ResourceTagName::new));
    }

    protected InventoryStatusName getWithStatus() {
        return this.parse(InventoryStatusName::new, this.mustFindString(new StepExtractor.JsonKey("status"), new StepExtractor.JsonPath("$.children[?(@.type == 'componentEnvironmentIterator')].children[?(@.type == '" + this.versionIterator + "')]")));
    }

    protected <R extends RemovalType> R getRemovalType(Function<String, R> ctor) {
        return (R)((RemovalType)this.parse(ctor, this.mustFindString(new StepExtractor.JsonKey("selectionType"), new StepExtractor.JsonPath("$.children[?(@.type == 'componentEnvironmentIterator')].children[?(@.type == '" + this.versionIterator + "')]"))));
    }

    protected InventoryStatusName getTargetInventoryStatus() {
        return this.parse(InventoryStatusName::new, this.mustFindString(new StepExtractor.JsonKey("status"), new StepExtractor.JsonPath("$.children[?(@.type == 'componentEnvironmentIterator')].children[?(@.type == '" + this.versionIterator + "')]")));
    }

    @Override
    protected Stream<Property> findProperties() {
        return Stream.empty();
    }
}

