/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.decompiler;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.compiler.Translator;
import ucd.pacc.compiler.TranslatorOptions;
import ucd.pacc.decompiler.ProcessMetaDataHandler;
import ucd.pacc.decompiler.ScriptExtractor;
import ucd.pacc.decompiler.UcdToUserJsonConvertor;
import ucd.pacc.main.ProcessType;
import ucd.pacc.model.StepGraph;
import ucd.pacc.parser.ParseException;
import ucd.pacc.parser.ParseSink;
import ucd.pacc.parser.ParseSource;
import ucd.pacc.parser.json.JsonParser;
import ucd.pacc.util.FileTypeConverter;

public class Decompiler
implements Translator {
    private final ParseSource source;
    private final ParseSink sink;
    String processType;
    String processName;
    String parentName;
    String outPutFileType;

    public Decompiler(ParseSource source, ParseSink sink, TranslatorOptions options) {
        this.source = source;
        this.source.getClass();
        this.sink = sink;
        this.sink.getClass();
        options.getClass();
    }

    public void setProcessType(ProcessType processType) {
        this.processType = processType.toString();
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public void setOutPutFileType(String outPutFileType) {
        this.outPutFileType = outPutFileType;
    }

    @Override
    public void translate() throws IOException, ParseException {
        JsonParser parser = new JsonParser();
        StepGraph graph = parser.parse(this.source);
        UcdToUserJsonConvertor convertor = new UcdToUserJsonConvertor();
        convertor.process(graph);
        JSONObject updatedProcessDesign = this.getJsonObject(convertor.getProcessJson());
        ProcessMetaDataHandler metaDataHandler = new ProcessMetaDataHandler(updatedProcessDesign, this.processType, this.processName, this.parentName);
        String finalOutput = metaDataHandler.addProcessMetaData();
        if (Objects.equals(this.outPutFileType, "yml")) {
            finalOutput = FileTypeConverter.jsonToYaml(finalOutput);
        }
        Writer out = this.sink.getWriter();
        out.write(finalOutput);
        out.write("\n");
    }

    private JSONObject getJsonObject(JSONObject processJsonDesign) {
        ScriptExtractor scriptExtractor = new ScriptExtractor(this.processName, this.parentName);
        JSONObject updatedProcessDesign = scriptExtractor.extractScriptFilesFromProcessDesignJson(processJsonDesign);
        return updatedProcessDesign;
    }
}

