/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import ucd.pacc.http.JsonEntity;
import ucd.pacc.parser.BadRootActivityException;
import ucd.pacc.parser.ParseException;

public class DeployProcessApi {
    private static final Charset HTTP_DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    static final int MAX_MESSAGE = 255;
    private CloseableHttpClient httpClient;
    private String baseUrl;

    public DeployProcessApi(CloseableHttpClient httpClient, String baseUrl) {
        this.httpClient = httpClient;
        this.httpClient.getClass();
        this.baseUrl = baseUrl;
        this.baseUrl.getClass();
    }

    public Optional<JsonObject> getApplicationProcess(UUID id, int version) throws IOException, ParseException {
        return this.getProcess("rest/deploy/applicationProcess/%s/%d", id, version);
    }

    public Optional<JsonObject> getComponentProcess(UUID id, int version) throws IOException, ParseException {
        return this.getProcess("rest/deploy/componentProcess/%s/%d", id, version);
    }

    public Optional<JsonObject> getGenericProcess(UUID id, int version) throws IOException, ParseException {
        return this.getProcess("rest/process/%s/%d", id, version);
    }

    /*
     * Exception decompiling
     */
    private Optional<JsonObject> getProcess(String urlTemplate, UUID id, int version) throws IOException, ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void putApplicationProcess(UUID id, int version, JsonObject object) throws IOException {
        this.putProcess("rest/deploy/applicationProcess/%s/saveActivities", "applicationProcessVersion", id, version, object);
    }

    public void putComponentProcess(UUID id, int version, JsonObject object) throws IOException {
        this.putProcess("rest/deploy/componentProcess/%s/saveActivities", "componentProcessVersion", id, version, object);
    }

    public void putGenericProcess(UUID id, int version, JsonObject object) throws IOException {
        this.putProcess("rest/process/%s/activities", "processVersion", id, version, object);
    }

    private void putProcess(String urlTemplate, String versionHeader, UUID id, int version, JsonObject object) throws IOException {
        urlTemplate.getClass();
        versionHeader.getClass();
        id.getClass();
        object.getClass();
        int headerVersion = Math.max(-1, version - 1);
        String url = this.joinUrl(String.format(urlTemplate, id, version));
        JsonEntity entity = new JsonEntity((JsonStructure)object);
        HttpPut httpPut = new HttpPut(url);
        httpPut.setEntity((HttpEntity)entity);
        httpPut.addHeader(versionHeader, String.valueOf(headerVersion));
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPut);){
            int status = response.getStatusLine().getStatusCode();
            if (!this.isSuccessStatus(status)) {
                Optional<String> message = this.getMessage((HttpResponse)response);
                if (message.isPresent()) {
                    throw new IOException(String.format("PUT failed: url={%s} status=%d message={%s}", url, status, message.get()));
                }
                throw new IOException(String.format("PUT failed: url={%s} status=%d", url, status));
            }
        }
    }

    private String joinUrl(String suffix) {
        String base = this.baseUrl;
        while (base.endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        return base + "/" + suffix;
    }

    private Optional<BufferedReader> getEntityReader(HttpResponse response) throws IOException {
        Optional<HttpEntity> entity = Optional.ofNullable(response.getEntity());
        if (!entity.isPresent()) {
            return Optional.empty();
        }
        Charset entityCharset = entity.map(ContentType::getOrDefault).map(ContentType::getCharset).orElse(HTTP_DEFAULT_CHARSET);
        return Optional.of(new BufferedReader(new InputStreamReader(entity.get().getContent(), entityCharset)));
    }

    private Optional<String> getMessage(HttpResponse response) throws IOException {
        Optional<BufferedReader> reader = this.getTextPlainEntityReader(response);
        if (!reader.isPresent()) {
            return Optional.empty();
        }
        try (BufferedReader r = reader.get();){
            int n;
            char[] buffer = new char[255];
            int total = 0;
            for (int remaining = buffer.length; remaining > 0 && (n = r.read(buffer, total, remaining)) != -1; remaining -= n) {
                total += n;
            }
            String message = new String(buffer, 0, total).trim();
            if (message.isEmpty()) {
                Optional<String> optional = Optional.empty();
                return optional;
            }
            Optional<String> optional = Optional.of(message);
            return optional;
        }
    }

    private Optional<BufferedReader> getTextPlainEntityReader(HttpResponse response) throws IOException {
        Optional<HttpEntity> entity = Optional.ofNullable(response.getEntity());
        if (!entity.isPresent()) {
            return Optional.empty();
        }
        Optional<ContentType> contentType = entity.map(ContentType::getOrDefault);
        boolean isTextPlain = contentType.map(ContentType::getMimeType).filter(mt -> mt.equalsIgnoreCase(ContentType.TEXT_PLAIN.getMimeType())).isPresent();
        if (!isTextPlain) {
            return Optional.empty();
        }
        Charset entityCharset = contentType.map(ContentType::getCharset).orElse(HTTP_DEFAULT_CHARSET);
        return Optional.of(new BufferedReader(new InputStreamReader(entity.get().getContent(), entityCharset)));
    }

    private boolean isSuccessStatus(int status) {
        return status >= 200 && status < 300;
    }

    private Optional<JsonObject> extractRootActivity(Reader reader) throws ParseException {
        JsonObject json = Json.createReader((Reader)reader).readObject();
        JsonValue rootValue = (JsonValue)json.get((Object)"rootActivity");
        if (rootValue == null) {
            return Optional.empty();
        }
        if (!(rootValue instanceof JsonObject)) {
            throw new BadRootActivityException(Optional.empty(), "'rootActivity' is not an object value");
        }
        JsonObject root = (JsonObject)rootValue;
        JsonValue typeValue = (JsonValue)root.get((Object)"type");
        if (typeValue == null) {
            throw new BadRootActivityException(Optional.empty(), "'rootActivity' does not appear to be process: 'type' not found");
        }
        if (!(typeValue instanceof JsonString)) {
            throw new BadRootActivityException(Optional.empty(), "'rootActivity' does not appear to be process: 'type' is not a string value");
        }
        String type = ((JsonString)typeValue).getString();
        if (!type.equals("graph")) {
            throw new BadRootActivityException(Optional.empty(), "'rootActivity' does not appear to be process: 'type' is not 'graph': type=" + type);
        }
        return Optional.of(root);
    }
}

