/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.main;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.Optional;
import java.util.UUID;
import javax.json.JsonObject;
import javax.json.spi.JsonProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import ucd.pacc.compiler.GraphJsonBuilder;
import ucd.pacc.compiler.Translator;
import ucd.pacc.compiler.TranslatorOptions;
import ucd.pacc.decompiler.Decompiler;
import ucd.pacc.decompiler.DecompilerFactory;
import ucd.pacc.http.DeployProcessApi;
import ucd.pacc.http.DeployProcessApiFactory;
import ucd.pacc.http.HttpClientFactory;
import ucd.pacc.main.AbstractProcessCommand;
import ucd.pacc.main.BadArgumentException;
import ucd.pacc.main.GlobalProcessState;
import ucd.pacc.main.ProcessMetaData;
import ucd.pacc.main.ProcessNameToIdConvertor;
import ucd.pacc.main.ProcessType;
import ucd.pacc.main.ServerDataGetter;
import ucd.pacc.model.ParseSinkName;
import ucd.pacc.model.ParseSourceName;
import ucd.pacc.model.StepActionFinish;
import ucd.pacc.model.StepGraph;
import ucd.pacc.parser.JsonObjectParseSource;
import ucd.pacc.parser.ParseException;
import ucd.pacc.parser.ParseSink;
import ucd.pacc.parser.analysis.PopulateStepByNameMapProcessor;
import ucd.pacc.util.ErrorHandler;
import ucd.pacc.util.IOFactory;

class DownloadProcessCommand
extends AbstractProcessCommand {
    private final DownloadMethod downloadMethod;
    private Optional<Arguments> arguments;
    private final ProcessMetaData metaData;

    DownloadProcessCommand(GlobalProcessState globalProcessState, IOFactory ioUtil, HttpClientFactory httpClientFactory, DeployProcessApiFactory deployProcessApiFactory, JsonProvider jsonProvider, DecompilerFactory decompilerFactory, DownloadMethod downloadMethod) {
        super(globalProcessState, ioUtil, httpClientFactory, deployProcessApiFactory, jsonProvider, decompilerFactory);
        this.downloadMethod = downloadMethod;
        this.downloadMethod.getClass();
        this.arguments = Optional.empty();
        this.metaData = new ProcessMetaData();
    }

    @Override
    protected void parseArguments() throws BadArgumentException {
        Path outputFile;
        String[] args = this.getGlobalProcessState().getArguments();
        this.validateArguments(args);
        String user = args[0];
        String pwd = args[1];
        String url = args[2];
        String processName = args[3];
        this.metaData.setProcessName(processName);
        if (this.getDownloadMethod().toString().contains("DownloadApplicationProcess")) {
            this.metaData.setProcessType(ProcessType.APPLICATION);
            this.metaData.setParentName(args[4]);
            outputFile = Paths.get(args[5], new String[0]);
        } else if (this.getDownloadMethod().toString().contains("DownloadComponentProcess")) {
            this.metaData.setProcessType(ProcessType.COMPONENT);
            this.metaData.setParentName(args[4]);
            outputFile = Paths.get(args[5], new String[0]);
        } else {
            this.metaData.setProcessType(ProcessType.GENERIC);
            outputFile = Paths.get(args[4], new String[0]);
        }
        ServerDataGetter dataGetter = ServerDataGetter.getServerDataGetter(user, pwd, url);
        ProcessNameToIdConvertor ProcessNameToIdConvertor2 = new ProcessNameToIdConvertor(this.metaData, dataGetter);
        UUID processId = this.parseProcessId(ProcessNameToIdConvertor2.getProcessId());
        if (this.metaData.getProcessType() == ProcessType.GENERIC) {
            this.metaData.setProcessVersion(ProcessNameToIdConvertor2.getProcessVersion());
        } else {
            this.metaData.setProcessVersion(-1);
        }
        this.arguments = Optional.of(new Arguments(user, url, processId, this.metaData.getProcessVersion(), outputFile, pwd));
    }

    public void validateArguments(String[] args) throws BadArgumentException {
        if (this.getDownloadMethod().toString().contains("DownloadGenericProcess") && args.length != 5) {
            throw new BadArgumentException(String.format("some arguments may be missing or not required. Usage: %s <user-name> <password> <server-url> <process-name> outputfile.json/yml", this.getGlobalProcessState().getProgramInfo().getName()));
        }
        if ((this.getDownloadMethod().toString().contains("DownloadComponentProcess") || this.getDownloadMethod().toString().contains("DownloadApplicationProcess")) && args.length != 6) {
            throw new BadArgumentException(String.format("some arguments may be missing or not required. Usage: %s <user-name> <password> <server-url> <process-name> <parent-name> outputfile.json/yml", this.getGlobalProcessState().getProgramInfo().getName()));
        }
        if (!ErrorHandler.isValidOperationFileType(args[args.length - 1])) {
            throw new BadArgumentException(String.format("Invalid output file type provided, Please provide any of these: json/yaml/yml", this.getGlobalProcessState().getProgramInfo().getName()));
        }
        if (!ErrorHandler.isValidUrl(args[2])) {
            throw new BadArgumentException(String.format("The Server Url provided is invalid. Please verify the URL", this.getGlobalProcessState().getProgramInfo().getName()));
        }
    }

    @Override
    protected void doProcessCommand() throws IOException, GeneralSecurityException, ParseException {
        Arguments arguments = this.getArguments().get();
        String password = arguments.getPassword();
        CharsetEncoder encoder = this.getCharset().newEncoder();
        try (CloseableHttpClient httpclient = this.getHttpClientFactory().create(arguments.getUser(), password);
             BufferedWriter bufferedWriter = this.getIOFactory().fileWriter(arguments.getOutputFile(), encoder);){
            DeployProcessApi api = this.getDeployProcessApiFactory().create(httpclient, arguments.getUrl());
            Optional<JsonObject> optionalProcess = this.getDownloadMethod().download(api, arguments.getProcessId(), arguments.getProcessVersion());
            JsonObject process = optionalProcess.isPresent() ? optionalProcess.get() : this.createEmptyProcessRootActivity();
            Translator translator = this.getTranslatorFactory().create(new JsonObjectParseSource(this.createParseSourceName(), process), new ParseSink(this.createParseSinkName(), bufferedWriter), TranslatorOptions.none());
            if (translator instanceof Decompiler) {
                Decompiler decompiler = (Decompiler)translator;
                if (arguments.getOutputFile().toString().contains("yml") || arguments.getOutputFile().toString().contains("yaml")) {
                    decompiler.setOutPutFileType("yml");
                }
                decompiler.setProcessType(this.metaData.getProcessType());
                decompiler.setProcessName(this.metaData.getProcessName());
                decompiler.setParentName(this.metaData.getParentName());
            }
            translator.translate();
        }
    }

    protected ParseSourceName createParseSourceName() {
        Arguments arguments = this.getArguments().get();
        UUID processId = arguments.getProcessId();
        int processVersion = arguments.getProcessVersion();
        if (processVersion == -1) {
            return new ParseSourceName(processId + ":latest");
        }
        return new ParseSourceName(processId + ":" + processVersion);
    }

    protected ParseSinkName createParseSinkName() {
        return new ParseSinkName(this.getArguments().get().getOutputFile().toString());
    }

    protected Optional<Arguments> getArguments() {
        return this.arguments;
    }

    protected DownloadMethod getDownloadMethod() {
        return this.downloadMethod;
    }

    private JsonObject createEmptyProcessRootActivity() throws ParseException {
        StepGraph graph = new StepGraph();
        GraphJsonBuilder graphBuilder = new GraphJsonBuilder();
        PopulateStepByNameMapProcessor processor = new PopulateStepByNameMapProcessor();
        StepActionFinish stepActionFinish = new StepActionFinish(graph.getFinishStep());
        graph.getStartStep().addAction(stepActionFinish);
        processor.process(graph);
        graphBuilder.process(graph);
        return graphBuilder.getJson();
    }

    protected static class Arguments {
        private final String user;
        private final String url;
        private final UUID processId;
        private final int processVersion;
        private final Path outputFile;
        private final String password;

        Arguments(String user, String url, UUID processId, int processVersion, Path outputFile, String password) {
            this.user = user;
            this.user.getClass();
            this.url = url;
            this.url.getClass();
            this.processId = processId;
            this.processId.getClass();
            this.processVersion = processVersion;
            this.outputFile = outputFile;
            this.outputFile.getClass();
            this.password = password;
            this.password.getClass();
        }

        protected String getUser() {
            return this.user;
        }

        protected String getUrl() {
            return this.url;
        }

        protected UUID getProcessId() {
            return this.processId;
        }

        protected int getProcessVersion() {
            return this.processVersion;
        }

        protected Path getOutputFile() {
            return this.outputFile;
        }

        protected String getPassword() {
            return this.password;
        }
    }

    static interface DownloadMethod {
        public Optional<JsonObject> download(DeployProcessApi var1, UUID var2, int var3) throws IOException, ParseException;
    }
}

