/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.main;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;

class SystemProperties {
    private static final String PACC_PROGRAM = "pacc.program";
    private static final String PACC_LOCATION = "pacc.location";
    private final Properties properties;

    SystemProperties(Properties properties) {
        this.properties = properties;
        this.properties.getClass();
    }

    public Optional<String> get(String name) {
        name.getClass();
        return Optional.ofNullable(this.getProperties().getProperty(name));
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProgramName() {
        return this.mustGet(PACC_PROGRAM);
    }

    public Path getProgramLocation() {
        return Paths.get(this.mustGet(PACC_LOCATION), new String[0]).toAbsolutePath().normalize();
    }

    private String mustGet(String name) {
        return this.get(name).orElseThrow(() -> new RuntimeException("required system property not set: " + name));
    }
}

