/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.main;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import ucd.pacc.compiler.Translator;
import ucd.pacc.compiler.TranslatorFactory;
import ucd.pacc.compiler.TranslatorOptions;
import ucd.pacc.main.AbstractCommand;
import ucd.pacc.main.BadArgumentException;
import ucd.pacc.main.GlobalProcessState;
import ucd.pacc.model.ParseSinkName;
import ucd.pacc.model.ParseSourceName;
import ucd.pacc.parser.ParseException;
import ucd.pacc.parser.ParseSink;
import ucd.pacc.parser.ReaderParseSource;
import ucd.pacc.util.IOFactory;

class TranslatorCommand
extends AbstractCommand {
    private final TranslatorFactory translatorFactory;

    TranslatorCommand(GlobalProcessState globalProcessState, IOFactory ioFactory, TranslatorFactory translatorFactory) {
        super(globalProcessState, ioFactory);
        this.translatorFactory = translatorFactory;
        this.translatorFactory.getClass();
    }

    @Override
    protected void doCommand() throws ParseException, IOException, GeneralSecurityException {
        GlobalProcessState gps = this.getGlobalProcessState();
        try (BufferedReader in = this.getIOFactory().streamReader(gps.getStdin(), this.getCharset().newDecoder());
             BufferedWriter out = this.getIOFactory().streamWriter(gps.getStdout(), this.getCharset().newEncoder());){
            Translator translator = this.getTranslatorFactory().create(new ReaderParseSource(new ParseSourceName("<stdin>"), in), new ParseSink(new ParseSinkName("<stdout>"), out), TranslatorOptions.none());
            translator.translate();
        }
    }

    @Override
    protected void parseArguments() throws BadArgumentException {
    }

    protected TranslatorFactory getTranslatorFactory() {
        return this.translatorFactory;
    }
}

