/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import ucd.pacc.model.ActionGroupStep;
import ucd.pacc.model.NotificationTemplateName;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.PropertyDefinition;
import ucd.pacc.model.PropertyDefinitionContainer;
import ucd.pacc.model.PropertyName;
import ucd.pacc.model.StepName;
import ucd.pacc.model.TaskApprovalRestriction;

public abstract class AbstractManualTaskStep
extends ActionGroupStep
implements PropertyDefinitionContainer {
    private final List<PropertyDefinition> propertyDefinitions;
    private Optional<NotificationTemplateName> notificationTemplate;
    private TaskApprovalRestriction approvalRestriction;

    protected AbstractManualTaskStep(ParseSourcePosition position, StepName name, TaskApprovalRestriction approvalRestriction) {
        super(position, name);
        this.approvalRestriction = approvalRestriction;
        this.approvalRestriction.getClass();
        this.propertyDefinitions = new ArrayList<PropertyDefinition>();
        this.notificationTemplate = Optional.empty();
    }

    @Override
    public void addPropertyDefinition(PropertyDefinition propertyDefinition) {
        propertyDefinition.getClass();
        this.propertyDefinitions.add(propertyDefinition);
    }

    @Override
    public List<PropertyDefinition> getPropertyDefinitions() {
        return Collections.unmodifiableList(this.propertyDefinitions);
    }

    @Override
    public Optional<PropertyDefinition> getPropertyDefinition(PropertyName name) {
        name.getClass();
        return this.getPropertyDefinitions().stream().filter(p -> p.getName().equals(name)).findAny();
    }

    public Optional<NotificationTemplateName> getNotificationTemplate() {
        return this.notificationTemplate;
    }

    public void setNotificationTemplate(Optional<NotificationTemplateName> notificationTemplate) {
        notificationTemplate.getClass();
        this.notificationTemplate = notificationTemplate;
    }

    public TaskApprovalRestriction getApprovalRestriction() {
        return this.approvalRestriction;
    }

    public void setApprovalRestriction(TaskApprovalRestriction approvalRestriction) {
        approvalRestriction.getClass();
        Class<?> klass = approvalRestriction.getClass();
        if (!this.getAcceptableTaskApprovalRestrictionTypes().contains(klass)) {
            throw new IllegalArgumentException("unacceptable task approval restriction type: " + klass.getName());
        }
        this.approvalRestriction = approvalRestriction;
    }

    public abstract String getJsonKeyword();

    protected abstract Set<Class<? extends TaskApprovalRestriction>> getAcceptableTaskApprovalRestrictionTypes();
}

