/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.analysis;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Optional;
import ucd.pacc.model.Step;
import ucd.pacc.model.StepAction;
import ucd.pacc.model.StepGraph;
import ucd.pacc.model.StepName;
import ucd.pacc.parser.ParseException;
import ucd.pacc.parser.StepCycleException;
import ucd.pacc.util.StepGraphProcessor;
import ucd.pacc.util.Util;

public class CheckNoCyclesProcessor
extends StepGraphProcessor<CheckNoCyclesProcessor> {
    @Override
    protected CheckNoCyclesProcessor createNestedInstance() {
        return new CheckNoCyclesProcessor();
    }

    @Override
    protected void processStep(Step step) throws ParseException {
    }

    @Override
    protected void processStepGraphStart(StepGraph graph) throws ParseException {
        new DFS(graph).search();
    }

    private class DFS {
        private final StepGraph graph;
        private final LinkedHashSet<StepName> visited;

        DFS(StepGraph graph) {
            this.graph = graph;
            this.graph.getClass();
            this.visited = new LinkedHashSet();
        }

        void search() throws ParseException {
            this.search(this.graph.getStartStep());
        }

        private void search(Step step) throws ParseException {
            StepName name = step.getName();
            if (this.visited.contains(name)) {
                throw new StepCycleException(Optional.of(step.getPosition()), "process contains a step cycle: " + this.getCycle(name));
            }
            this.visited.add(name);
            for (StepAction e : Util.toSingleUseIterable(step.getActionStream())) {
                this.search((Step)this.graph.getStepByName(e.getTarget()).get());
            }
            this.visited.remove(name);
        }

        private String getCycle(StepName beginning) {
            ArrayList<String> cycle = new ArrayList<String>();
            boolean inCycle = false;
            for (StepName v : this.visited) {
                if (!(inCycle = inCycle || v.equals(beginning))) continue;
                cycle.add(v.quote());
            }
            cycle.add(beginning.quote());
            return String.join((CharSequence)"->", cycle);
        }
    }
}

