/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.analysis;

import java.util.HashSet;
import java.util.Optional;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.Property;
import ucd.pacc.model.PropertyContainer;
import ucd.pacc.model.PropertyName;
import ucd.pacc.model.Step;
import ucd.pacc.parser.NonUniquePropertyNameException;
import ucd.pacc.parser.ParseException;
import ucd.pacc.util.StepGraphProcessor;

public class CheckPropertyNameUniquenessProcessor
extends StepGraphProcessor<CheckPropertyNameUniquenessProcessor> {
    @Override
    protected CheckPropertyNameUniquenessProcessor createNestedInstance() {
        return new CheckPropertyNameUniquenessProcessor();
    }

    @Override
    protected void processStep(Step step) throws ParseException {
        if (step instanceof PropertyContainer) {
            this.checkPropertyNameUniqueness(step, (PropertyContainer)((Object)step));
        }
    }

    protected void checkPropertyNameUniqueness(Step step, PropertyContainer container) throws ParseException {
        HashSet<PropertyName> names = new HashSet<PropertyName>();
        for (Property property : container.getProperties()) {
            PropertyName name = property.getName();
            if (names.add(name)) continue;
            ParseSourcePosition position = property.getPosition().orElse(step.getPosition());
            throw new NonUniquePropertyNameException(Optional.of(position), String.format("non-unique property name: step=%s property=%s", step.getName().quote(), name.quote()));
        }
    }
}

