/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.json;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonObject;
import ucd.pacc.model.AppProcessStep;
import ucd.pacc.model.ComponentName;
import ucd.pacc.model.InventoryStatusName;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.ProcessName;
import ucd.pacc.model.Property;
import ucd.pacc.model.RemovalType;
import ucd.pacc.model.StepName;
import ucd.pacc.parser.json.StepExtractor;
import ucd.pacc.parser.json.StepExtractorAppProcess;
import ucd.pacc.util.JsonUtil;

abstract class StepExtractorAppSingleComponent<T extends AppProcessStep>
extends StepExtractorAppProcess<T> {
    private final String versionIterator;

    StepExtractorAppSingleComponent(ParseSourcePosition position, JsonObject object, String context, JsonUtil jsonUtil, String versionIterator) {
        super(position, object, context, jsonUtil);
        this.versionIterator = versionIterator;
        this.versionIterator.getClass();
    }

    @Override
    protected StepName getStepName() {
        return this.parse(StepName::new, this.mustFindString(new StepExtractor.JsonKey("name"), new StepExtractor.JsonPath("$.children[?(@.type == '" + this.versionIterator + "')].children[?(@.type == 'componentProcess')]")));
    }

    @Override
    protected Stream<Property> findProperties() {
        Optional<JsonObject> properties = this.findJsonObject(new StepExtractor.JsonKey("properties"), new StepExtractor.JsonPath("$.children[?(@.type == '" + this.versionIterator + "')].children[?(@.type == 'componentProcess')]"));
        if (!properties.isPresent()) {
            return Stream.empty();
        }
        return properties.get().entrySet().stream().map(this::extractProperty);
    }

    protected ComponentName getComponentName() {
        return this.parse(ComponentName::new, this.mustGetString("componentName"));
    }

    @Override
    protected ProcessName getProcessName() {
        return this.parse(ProcessName::new, this.mustFindString(new StepExtractor.JsonKey("componentProcessName"), new StepExtractor.JsonPath("$.children[?(@.type == '" + this.versionIterator + "')].children[?(@.type == 'componentProcess')]")));
    }

    protected InventoryStatusName getTargetInventoryStatus() {
        return this.parse(InventoryStatusName::new, this.mustFindString(new StepExtractor.JsonKey("status"), new StepExtractor.JsonPath("$.children[?(@.type == '" + this.versionIterator + "')]")));
    }

    protected <R extends RemovalType> R getRemovalType(Function<String, R> ctor) {
        return (R)((RemovalType)this.parse(ctor, this.mustFindString(new StepExtractor.JsonKey("selectionType"), new StepExtractor.JsonPath("$.children[?(@.type == '" + this.versionIterator + "')]"))));
    }
}

