/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonStructure;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.util.TripleUnquoter;

public class Util {
    public static <T> Function<Object, Stream<T>> asInstanceofStream(Class<T> klass) {
        return object -> {
            if (klass.isInstance(object)) {
                return Stream.of(klass.cast(object));
            }
            return Stream.empty();
        };
    }

    public static <T> Function<Object, Optional<T>> asInstanceofOptional(Class<T> klass) {
        return object -> {
            if (klass.isInstance(object)) {
                return Optional.of(klass.cast(object));
            }
            return Optional.empty();
        };
    }

    public static <T> Iterable<T> toSingleUseIterable(Stream<T> s) {
        s.getClass();
        return s::iterator;
    }

    public static <T> Stream<T> stream(Optional<T> opt) {
        if (opt.isPresent()) {
            return Stream.of(opt.get());
        }
        return Stream.empty();
    }

    @SafeVarargs
    public static <T> Stream<T> concat(Stream<? extends T> ... streams) {
        return Arrays.stream(streams).flatMap(Function.identity());
    }

    public static <T> void ifPresentOrElse(Optional<T> optional, Consumer<? super T> action, Runnable emptyAction) {
        if (optional.isPresent()) {
            optional.ifPresent(action);
        } else {
            emptyAction.run();
        }
    }

    public static String quote(String s) {
        return '\"' + Util.escape(s) + '\"';
    }

    public static String escape(String s) {
        int i;
        int len = s.length();
        block3: for (i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '\\': {
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        if (i >= len) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(s, 0, i);
        while (i < len) {
            Util.escape(s.charAt(i), sb);
            ++i;
        }
        return sb.toString();
    }

    private static void escape(char c, StringBuilder sb) {
        switch (c) {
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            case '\"': {
                sb.append("\\\"");
                break;
            }
            case '\\': {
                sb.append("\\\\");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    public static String unquote(String text) {
        return Util.unescape(text.substring(1, text.length() - 1));
    }

    public static String tripleUnquoteAndRemoveIndent(String text, ParseSourcePosition position) {
        return new TripleUnquoter(text, position).unquote();
    }

    public static <K, V> Map<K, V> nullFreeCopy(Map<K, V> src) {
        Map<Object, Object> dst = Collections.unmodifiableMap(new HashMap<K, V>(src));
        dst.forEach((key, val) -> {
            Objects.requireNonNull(key, "null key");
            Objects.requireNonNull(val, "null value");
        });
        return dst;
    }

    public static <V> List<V> nullFreeCopy(List<V> src) {
        List<V> dst = Collections.unmodifiableList(new ArrayList<V>(src));
        dst.forEach(Objects::requireNonNull);
        return dst;
    }

    public static String unescape(String s) {
        if (s.indexOf(92) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            if (c == 92 && !escape) {
                escape = true;
                continue;
            }
            if (escape) {
                escape = false;
                switch (c) {
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 34: {
                        c = 34;
                        break;
                    }
                }
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String toPrettyString(JsonStructure structure) {
        StringWriter out = new StringWriter();
        Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", null)).createWriter((Writer)out).write(structure);
        return out.toString();
    }

    public static boolean isNotEmpty(String s) {
        return !s.isEmpty();
    }
}

