/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.http;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.json.Json;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import org.apache.http.entity.AbstractHttpEntity;

public class JsonEntity
extends AbstractHttpEntity {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final String CONTENT_TYPE = "application/json; charset=" + CHARSET.name();
    private JsonStructure value;

    public JsonEntity(JsonStructure value) {
        this.value = value;
        this.value.getClass();
        this.setContentType(CONTENT_TYPE);
    }

    public JsonStructure getValue() {
        return this.value;
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return -1L;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeTo(out);
        return new ByteArrayInputStream(out.toByteArray());
    }

    public void writeTo(OutputStream outStream) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(outStream);
             OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)out, CHARSET);
             JsonWriter jsonWriter = Json.createWriter((Writer)outWriter);){
            jsonWriter.write(this.getValue());
        }
    }

    public boolean isStreaming() {
        return false;
    }
}

