/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ucd.pacc.model.FinishStep;
import ucd.pacc.model.StartStep;
import ucd.pacc.model.Step;
import ucd.pacc.model.StepGraphContainer;
import ucd.pacc.model.StepName;
import ucd.pacc.util.Util;

public class StepGraph
implements StepGraphContainer {
    private final StartStep startStep = new StartStep();
    private final FinishStep finishStep = new FinishStep();
    private final List<Step> steps = new ArrayList<Step>();
    private Optional<Map<StepName, Step>> stepByNameMap = Optional.empty();
    private Optional<Map<StepName, Step>> stepByAnchorMap = Optional.empty();

    public StepGraph() {
        this.steps.add(this.getStartStep());
        this.steps.add(this.getFinishStep());
    }

    @Override
    public StepGraph getGraph() {
        return this;
    }

    public StartStep getStartStep() {
        return this.startStep;
    }

    public FinishStep getFinishStep() {
        return this.finishStep;
    }

    public void addStep(Step step) {
        step.getClass();
        if (step instanceof FinishStep) {
            throw new IllegalArgumentException("cannot add finish step: name=" + step.getName());
        }
        if (step instanceof StartStep) {
            throw new IllegalArgumentException("cannot add start step: name=" + step.getName());
        }
        this.steps.add(step);
    }

    public List<Step> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    public Optional<Map<StepName, Step>> getStepByNameMap() {
        return this.stepByNameMap;
    }

    public void setStepByNameMap(Optional<Map<StepName, Step>> stepByNameMap) {
        stepByNameMap.getClass();
        this.stepByNameMap = stepByNameMap.map(Util::nullFreeCopy);
    }

    public <T extends Step> Optional<T> getStepByName(StepName name) {
        return this.getStepByNameMap().flatMap(m -> Optional.ofNullable(m.get(name)));
    }

    public Optional<Map<StepName, Step>> getStepByAnchorMap() {
        return this.stepByAnchorMap;
    }

    public void setStepByAnchorMap(Optional<Map<StepName, Step>> stepByAnchorMap) {
        stepByAnchorMap.getClass();
        this.stepByAnchorMap = stepByAnchorMap;
    }

    public <T extends Step> Optional<T> getStepByAnchor(StepName anchor) {
        return this.getStepByAnchorMap().flatMap(m -> Optional.ofNullable(m.get(anchor)));
    }
}

