/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.analysis;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.Step;
import ucd.pacc.model.StepAction;
import ucd.pacc.model.StepActionFinish;
import ucd.pacc.model.StepGraph;
import ucd.pacc.model.StepName;
import ucd.pacc.parser.NoSuchStepException;
import ucd.pacc.parser.ParseException;
import ucd.pacc.util.StepGraphProcessor;

public class CheckMissingActionTargetProcessor
extends StepGraphProcessor<CheckMissingActionTargetProcessor> {
    private final Set<StepActionTuple> stepActionTuples = new HashSet<StepActionTuple>();

    @Override
    protected CheckMissingActionTargetProcessor createNestedInstance() {
        return new CheckMissingActionTargetProcessor();
    }

    @Override
    protected void processStep(Step step) throws ParseException {
        this.collectActions(step);
    }

    @Override
    protected void processStepGraphEnd(StepGraph graph) throws ParseException {
        for (StepActionTuple tuple : this.stepActionTuples) {
            StepName target = tuple.getTarget();
            if (graph.getStepByName(target).isPresent()) continue;
            throw new NoSuchStepException(Optional.of(tuple.getPosition()), "missing target step: step=" + target.quote(), target);
        }
    }

    protected void collectActions(Step step) throws ParseException {
        step.getActionStream().filter(action -> !(action instanceof StepActionFinish)).map(action -> new StepActionTuple(step, (StepAction)action)).forEach(this.stepActionTuples::add);
    }

    private static class StepActionTuple {
        final Step owner;
        final StepAction action;

        StepActionTuple(Step owner, StepAction action) {
            this.owner = owner;
            this.owner.getClass();
            this.action = action;
            this.action.getClass();
        }

        StepName getTarget() {
            return this.action.getTarget();
        }

        ParseSourcePosition getPosition() {
            return this.action.getPosition().orElse(this.owner.getPosition());
        }

        public boolean equals(Object obj) {
            if (obj instanceof StepActionTuple) {
                StepActionTuple rhs = (StepActionTuple)obj;
                return this.getTarget().equals(rhs.getTarget());
            }
            return false;
        }

        public int hashCode() {
            return this.getTarget().hashCode();
        }
    }
}

