/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ucd.pacc.model.ActionGroupStep;
import ucd.pacc.model.Concurrency;
import ucd.pacc.model.FinishStep;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.ResourceTagName;
import ucd.pacc.model.Step;
import ucd.pacc.model.StepGraph;
import ucd.pacc.model.StepGraphContainer;
import ucd.pacc.model.StepName;

public class ForEachResourceTagStep
extends ActionGroupStep
implements StepGraphContainer {
    private final List<ResourceTagName> tags = new ArrayList<ResourceTagName>();
    private StepGraph graph;
    private Concurrency maxConcurrentTags = Concurrency.limited(1);

    public ForEachResourceTagStep(ParseSourcePosition position, StepName name) {
        super(position, name);
        this.graph = new StepGraph();
    }

    public void addTag(ResourceTagName tag) {
        tag.getClass();
        this.tags.add(tag);
    }

    public List<ResourceTagName> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public Concurrency getMaxConcurrentTags() {
        return this.maxConcurrentTags;
    }

    public void setMaxConcurrentTags(Concurrency maxConcurrentTags) {
        maxConcurrentTags.getClass();
        this.maxConcurrentTags = maxConcurrentTags;
    }

    public void addStep(Step step) {
        step.getClass();
        this.getGraph().addStep(step);
    }

    @Override
    public StepGraph getGraph() {
        return this.graph;
    }

    public void setGraph(StepGraph graph) {
        graph.getClass();
        this.graph = graph;
    }

    public FinishStep getFinishStep() {
        return this.getGraph().getFinishStep();
    }

    @Override
    public String getPacStepKeyword() {
        return "for-each-resource-tag";
    }
}

