/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ucd.pacc.model.ActionGroupStep;
import ucd.pacc.model.Concurrency;
import ucd.pacc.model.FinishStep;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.ResourceTagName;
import ucd.pacc.model.Step;
import ucd.pacc.model.StepGraph;
import ucd.pacc.model.StepGraphContainer;
import ucd.pacc.model.StepName;

public class ForEachAgentStep
extends ActionGroupStep
implements StepGraphContainer {
    private final List<ResourceTagName> tags;
    private StepGraph graph;
    private Concurrency maxConcurrentAgents = Concurrency.unlimited();

    public ForEachAgentStep(ParseSourcePosition position, StepName name) {
        super(position, name);
        this.graph = new StepGraph();
        this.tags = new ArrayList<ResourceTagName>();
    }

    public void addTag(ResourceTagName tag) {
        tag.getClass();
        this.tags.add(tag);
    }

    public List<ResourceTagName> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public Concurrency getMaxConcurrentAgents() {
        return this.maxConcurrentAgents;
    }

    public void setMaxConcurrentAgents(Concurrency maxConcurrentAgents) {
        maxConcurrentAgents.getClass();
        this.maxConcurrentAgents = maxConcurrentAgents;
    }

    public void addStep(Step step) {
        step.getClass();
        this.getGraph().addStep(step);
    }

    @Override
    public StepGraph getGraph() {
        return this.graph;
    }

    public void setGraph(StepGraph graph) {
        graph.getClass();
        this.graph = graph;
    }

    public FinishStep getFinishStep() {
        return this.getGraph().getFinishStep();
    }

    @Override
    public String getPacStepKeyword() {
        return "for-each-agent";
    }
}

