/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.pac;

import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import ucd.pacc.model.MultiSelectPropertyDefinitionOptions;
import ucd.pacc.model.SelectPropertyDefinitionOptions;
import ucd.pacc.model.SelectPropertyValue;
import ucd.pacc.parser.SyntaxException;
import ucd.pacc.parser.pac.SelectPropertyValueNode;
import ucd.pacc.util.ParseExceptionCarrierException;

class SelectPropertyValueCollector
implements Collector<SelectPropertyValueNode, SelectPropertyValueList, SelectPropertyValueList> {
    private final boolean singleDefaultValue;

    public static SelectPropertyValueCollector forSingleDefaultValue() {
        return new SelectPropertyValueCollector(true);
    }

    public static SelectPropertyValueCollector forMultipleDefaultValues() {
        return new SelectPropertyValueCollector(false);
    }

    private SelectPropertyValueCollector(boolean singleDefaultValue) {
        this.singleDefaultValue = singleDefaultValue;
    }

    @Override
    public Supplier<SelectPropertyValueList> supplier() {
        return () -> new SelectPropertyValueList(this.singleDefaultValue);
    }

    @Override
    public BiConsumer<SelectPropertyValueList, SelectPropertyValueNode> accumulator() {
        return (rec$, x$0) -> ((SelectPropertyValueList)rec$).addValueNode(x$0);
    }

    @Override
    public BinaryOperator<SelectPropertyValueList> combiner() {
        return (rec$, x$0) -> ((SelectPropertyValueList)rec$).combine((SelectPropertyValueList)x$0);
    }

    @Override
    public Function<SelectPropertyValueList, SelectPropertyValueList> finisher() {
        return Function.identity();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
    }

    static class SelectPropertyValueList {
        private final LinkedHashSet<SelectPropertyValue> values;
        private final LinkedHashSet<SelectPropertyValueNode> defaultValues;
        private final boolean singleDefaultValue;

        private SelectPropertyValueList(boolean singleDefaultValue) {
            this.singleDefaultValue = singleDefaultValue;
            this.defaultValues = new LinkedHashSet();
            this.values = new LinkedHashSet();
        }

        private void addValueNode(SelectPropertyValueNode node) {
            SelectPropertyValue value = node.getValue();
            this.addValue(value);
            if (node.isSelected()) {
                this.addDefaultValue(node);
            }
        }

        private SelectPropertyValueList combine(SelectPropertyValueList right) {
            this.values.addAll(right.values);
            right.defaultValues.forEach(this::addDefaultValue);
            return this;
        }

        private void addDefaultValue(SelectPropertyValueNode node) {
            node.getClass();
            if (this.singleDefaultValue && !this.defaultValues.isEmpty()) {
                throw new ParseExceptionCarrierException(new SyntaxException(Optional.of(node.getPosition()), "multiple values selected for select property definition default: value=" + node.getValue().quote()));
            }
            this.defaultValues.add(node);
        }

        private void addValue(SelectPropertyValue value) {
            value.getClass();
            this.values.add(value);
        }

        public void copyToOptions(SelectPropertyDefinitionOptions options) {
            options.getClass();
            if (!this.singleDefaultValue) {
                throw new IllegalStateException();
            }
            this.values.forEach(options::addValue);
            options.setDefaultValue(this.defaultValues.stream().findAny().map(SelectPropertyValueNode::getValue));
        }

        public void copyToOptions(MultiSelectPropertyDefinitionOptions options) {
            options.getClass();
            if (this.singleDefaultValue) {
                throw new IllegalStateException();
            }
            this.values.forEach(options::addValue);
            this.defaultValues.stream().map(SelectPropertyValueNode::getValue).forEach(options::addDefaultValue);
        }
    }
}

