/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.main;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ScriptInjector {
    static final String SCRIPT_FILE = "scriptFile";
    static final String PROPERTIES = "properties";
    static final String SPACE_AS_HEX = "%20";
    static final int FILENAME_BEGIN_INDEX = "scriptFile".length() + 1;

    public JSONObject injectScriptFilesIntoProcessDesignJson(JSONObject processSteps) {
        Iterator keys = processSteps.keys();
        JSONObject resultJson = new JSONObject();
        while (keys.hasNext()) {
            String stepName = (String)keys.next();
            try {
                JSONObject stepJson = (JSONObject)this.getValueFromJson(stepName, processSteps);
                if (this.isStepPluginType(stepJson)) {
                    stepJson = this.getAllScriptFilesContentAndUpdatePropertyObject(stepJson);
                }
                resultJson.put(stepName, (Object)stepJson);
            }
            catch (JsonProcessingException | JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return resultJson;
    }

    JSONObject getAllScriptFilesContentAndUpdatePropertyObject(JSONObject stepJson) throws JSONException, JsonProcessingException {
        JSONObject pluginProperties = (JSONObject)this.getValueFromJson(PROPERTIES, stepJson);
        try {
            Iterator keysIterator = pluginProperties.keys();
            while (keysIterator.hasNext()) {
                String pluginPropertyKey = (String)keysIterator.next();
                String pluginPropertyValue = (String)pluginProperties.get(pluginPropertyKey);
                if (!pluginPropertyValue.startsWith(SCRIPT_FILE)) continue;
                pluginProperties.put(pluginPropertyKey, (Object)this.extractScriptBodyFromFile(pluginPropertyValue));
            }
            stepJson.put(PROPERTIES, (Object)pluginProperties);
            return stepJson;
        }
        catch (JSONException e) {
            throw new JSONException("Something is wrong with the plugin step JSON: " + e.getMessage());
        }
    }

    public String extractScriptBodyFromFile(String scriptFilePath) {
        String scriptFileName = scriptFilePath.substring(FILENAME_BEGIN_INDEX);
        StringBuilder scriptBody = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(scriptFileName));){
            String line;
            while ((line = reader.readLine()) != null) {
                scriptBody.append(line);
                scriptBody.append("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return scriptBody.toString();
    }

    protected Optional<Object> getOptionalValueFromJson(String key, JSONObject json) {
        try {
            return Optional.of(this.getValueFromJson(key, json));
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    protected Object getValueFromJson(String key, JSONObject json) throws JSONException {
        Object value = json.get(key);
        return value;
    }

    protected boolean isStepPluginType(JSONObject stepJson) {
        return this.getOptionalValueFromJson("plugin", stepJson).isPresent();
    }

    public String replaceSpaces(String input) {
        if (input == null) {
            return null;
        }
        return input.replace(" ", SPACE_AS_HEX);
    }
}

