/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import java.util.Optional;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.PropertyDefinitionOptions;
import ucd.pacc.model.PropertyDefinitionType;
import ucd.pacc.model.PropertyDescription;
import ucd.pacc.model.PropertyLabel;
import ucd.pacc.model.PropertyName;
import ucd.pacc.model.PropertyPattern;
import ucd.pacc.model.Step;
import ucd.pacc.parser.ParseException;

public class PropertyDefinition {
    private final PropertyDefinitionType type;
    private final PropertyName name;
    private Optional<PropertyDefinitionOptions> options;
    private Optional<ParseSourcePosition> position;

    public PropertyDefinition(PropertyDefinitionType type, PropertyName name) {
        this.type = type;
        this.type.getClass();
        this.name = name;
        this.name.getClass();
        this.options = Optional.empty();
        this.position = Optional.empty();
    }

    public PropertyDefinitionType getType() {
        return this.type;
    }

    public PropertyName getName() {
        return this.name;
    }

    public Optional<PropertyDefinitionOptions> getOptions() {
        return this.options;
    }

    public void setOptions(Optional<PropertyDefinitionOptions> options) {
        options.getClass();
        options.ifPresent(o -> {
            if (!this.type.isOptionsCompatible((PropertyDefinitionOptions)o)) {
                throw new IllegalArgumentException("incompatible options type: type=" + this.type + " options=" + options.getClass());
            }
        });
        this.options = options;
    }

    public Optional<ParseSourcePosition> getPosition() {
        return this.position;
    }

    public void setPosition(Optional<ParseSourcePosition> position) {
        position.getClass();
        this.position = position;
    }

    public String getJsonKeyword() {
        return this.getType().getJsonKeyword();
    }

    public String getPacKeyword() {
        return this.getType().getPacKeyword();
    }

    public String getPacOptionsKeyword() {
        return this.getType().getPacOptionsKeyword();
    }

    public Optional<PropertyLabel> getLabel() {
        return this.getOptions().flatMap(PropertyDefinitionOptions::getLabel);
    }

    public Optional<PropertyDescription> getDescription() {
        return this.getOptions().flatMap(PropertyDefinitionOptions::getDescription);
    }

    public Optional<PropertyPattern> getPattern() {
        return this.getOptions().flatMap(PropertyDefinitionOptions::getPattern);
    }

    public boolean isRequired() {
        return this.getOptions().map(PropertyDefinitionOptions::isRequired).orElse(false);
    }

    public void checkDefaultAgainstPattern(Step step) throws ParseException {
        Optional<PropertyDefinitionOptions> options = this.getOptions();
        if (options.isPresent()) {
            options.get().checkDefaultAgainstPattern(step, this);
        }
    }
}

