/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.json;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import ucd.pacc.model.ApplicationRunComponentProcessStep;
import ucd.pacc.model.ChangedComponentResourceListSelection;
import ucd.pacc.model.ChangedComponentResourceSelectionMode;
import ucd.pacc.model.ComponentName;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.ProcessName;
import ucd.pacc.model.Property;
import ucd.pacc.model.StepName;
import ucd.pacc.parser.json.StepExtractor;
import ucd.pacc.util.JsonUtil;
import ucd.pacc.util.Util;

abstract class StepExtractorApplicationRunComponentProcess
extends StepExtractor<ApplicationRunComponentProcessStep> {
    StepExtractorApplicationRunComponentProcess(ParseSourcePosition position, JsonObject object, JsonUtil jsonUtil) {
        super(position, object, "run component process step", jsonUtil);
    }

    @Override
    public ApplicationRunComponentProcessStep extract() {
        ApplicationRunComponentProcessStep step = new ApplicationRunComponentProcessStep(this.position, this.getStepName(), this.getComponentName(), this.getProcessName());
        step.setAnchor(this.getAnchor());
        step.setByResourceTag(this.getByResourceTag());
        step.setByChangedComponent(this.getByChangedComponent());
        this.getMaxConcurrentProcesses().ifPresent(step::setMaxConcurrentProcesses);
        this.getFailFast().ifPresent(step::setFailFast);
        this.getIgnoreChildWarnings().ifPresent(step::setIgnoreChildWarnings);
        this.getRunOnFirstOnlineResourceOnly().ifPresent(step::setRunOnFirstOnlineResourceOnly);
        step.setPreconditionScript(this.getPreconditionScript());
        this.findProperties().forEach(step::addProperty);
        return step;
    }

    @Override
    protected StepName getStepName() {
        return this.parse(StepName::new, this.mustFindString(new StepExtractor.JsonKey("name"), new StepExtractor.JsonPath("$.children[?(@.type == 'componentProcess')]")));
    }

    protected ComponentName getComponentName() {
        return this.parse(ComponentName::new, this.mustFindString(new StepExtractor.JsonKey("componentName"), new StepExtractor.JsonPath("$.children[?(@.type == 'componentProcess')]")));
    }

    protected ProcessName getProcessName() {
        return this.parse(ProcessName::new, this.mustFindString(new StepExtractor.JsonKey("componentProcessName"), new StepExtractor.JsonPath("$.children[?(@.type == 'componentProcess')]")));
    }

    @Override
    protected Stream<Property> findProperties() {
        Optional<JsonObject> properties = this.findJsonObject(new StepExtractor.JsonKey("properties"), new StepExtractor.JsonPath("$.children[?(@.type == 'componentProcess')]"));
        if (!properties.isPresent()) {
            return Stream.empty();
        }
        return properties.get().entrySet().stream().map(this::extractProperty);
    }

    protected abstract Optional<ChangedComponentResourceListSelection> getByChangedComponent();

    static class WithChangedComponents
    extends StepExtractorApplicationRunComponentProcess {
        WithChangedComponents(ParseSourcePosition position, JsonObject object, JsonUtil jsonUtil) {
            super(position, object, jsonUtil);
        }

        @Override
        protected Optional<ChangedComponentResourceListSelection> getByChangedComponent() {
            ChangedComponentResourceListSelection result = new ChangedComponentResourceListSelection(this.getSelectionMode());
            this.getComponentIdStrings().map(s -> this.parse(ComponentName::new, (String)s)).forEach(result::addComponent);
            return Optional.of(result);
        }

        private ChangedComponentResourceSelectionMode getSelectionMode() {
            return this.parse(ChangedComponentResourceSelectionMode::getForJsonKeyword, this.mustFindString(new StepExtractor.JsonKey("resourceSelectionMode"), BASE));
        }

        private Stream<String> getComponentIdStrings() {
            return Optional.ofNullable(this.object.get((Object)"componentIds")).map(ids -> {
                switch (ids.getValueType()) {
                    case ARRAY: {
                        JsonArray array = (JsonArray)ids;
                        return array.stream().peek(id -> this.checkIsJsonString("componentIds", (JsonValue)id)).map(JsonString.class::cast).map(JsonString::getString);
                    }
                    case STRING: {
                        String string = ((JsonString)ids).getString();
                        return Arrays.stream(string.split("\\s*,\\s*")).map(String::trim).filter(Util::isNotEmpty);
                    }
                }
                throw this.createSyntaxExceptionCarrier("unparseable value for field 'componentIds' in " + this.context);
            }).orElse(Stream.empty());
        }
    }

    static class WithoutChangedComponents
    extends StepExtractorApplicationRunComponentProcess {
        WithoutChangedComponents(ParseSourcePosition position, JsonObject object, JsonUtil jsonUtil) {
            super(position, object, jsonUtil);
        }

        @Override
        protected Optional<ChangedComponentResourceListSelection> getByChangedComponent() {
            return Optional.empty();
        }
    }
}

