/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import ucd.pacc.model.AbstractStep;
import ucd.pacc.model.ActionContainer;
import ucd.pacc.model.ActionView;
import ucd.pacc.model.CaseMatch;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.PropertyNameOrExpression;
import ucd.pacc.model.StepAction;
import ucd.pacc.model.StepName;

public class SwitchStep
extends AbstractStep
implements ActionView {
    private final List<SwitchStepMatchCase> matchCases;
    private PropertyNameOrExpression expression;
    private Optional<SwitchStepDefaultCase> defaultCase;

    public SwitchStep(ParseSourcePosition position, StepName name, PropertyNameOrExpression expression) {
        super(position, name);
        this.expression = expression;
        this.expression.getClass();
        this.matchCases = new ArrayList<SwitchStepMatchCase>();
        this.defaultCase = Optional.empty();
    }

    public PropertyNameOrExpression getExpression() {
        return this.expression;
    }

    public void setExpression(PropertyNameOrExpression expression) {
        expression.getClass();
        this.expression = expression;
    }

    public List<SwitchStepMatchCase> getMatchCases() {
        return Collections.unmodifiableList(this.matchCases);
    }

    public void addMatchCase(SwitchStepMatchCase matchCase) {
        matchCase.getClass();
        this.matchCases.add(matchCase);
    }

    public Optional<SwitchStepMatchCase> getMatchCase(CaseMatch match) {
        match.getClass();
        return this.getMatchCases().stream().filter(c -> c.getMatch().equals(match)).findAny();
    }

    public SwitchStepMatchCase getOrCreateMatchCase(CaseMatch match) {
        return this.getMatchCase(match).orElseGet(() -> {
            SwitchStepMatchCase m = new SwitchStepMatchCase(match);
            this.addMatchCase(m);
            return m;
        });
    }

    public Optional<SwitchStepDefaultCase> getDefaultCase() {
        return this.defaultCase;
    }

    public void setDefaultCase(Optional<SwitchStepDefaultCase> defaultCase) {
        defaultCase.getClass();
        this.defaultCase = defaultCase;
    }

    public SwitchStepDefaultCase getOrCreateDefaultCase() {
        Optional<SwitchStepDefaultCase> defaultCase = this.getDefaultCase();
        if (defaultCase.isPresent()) {
            return defaultCase.get();
        }
        SwitchStepDefaultCase kase = new SwitchStepDefaultCase();
        this.setDefaultCase(Optional.of(kase));
        return kase;
    }

    @Override
    public Stream<StepAction> getActionStream() {
        return Stream.concat(this.getMatchCases().stream().flatMap(ActionView::getActionStream), this.getDefaultCase().map(ActionView::getActionStream).orElse(Stream.empty()));
    }

    @Override
    public String toString() {
        return "{ " + this.getPacStepKeyword() + " " + this.getName().quote() + " expression=" + this.getExpression().quote() + "}";
    }

    @Override
    public String getPacStepKeyword() {
        return "switch";
    }

    public static class SwitchStepDefaultCase
    extends SwitchStepCase {
    }

    public static class SwitchStepMatchCase
    extends SwitchStepCase {
        private final CaseMatch match;

        public SwitchStepMatchCase(CaseMatch match) {
            this.match = match;
            this.match.getClass();
        }

        public CaseMatch getMatch() {
            return this.match;
        }
    }

    public static abstract class SwitchStepCase
    implements ActionContainer {
        private final List<StepAction> actions = new ArrayList<StepAction>();

        protected SwitchStepCase() {
        }

        @Override
        public void addAction(StepAction action) {
            action.getClass();
            this.actions.add(action);
        }

        @Override
        public List<StepAction> getActions() {
            return Collections.unmodifiableList(this.actions);
        }
    }
}

