/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.compiler;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import javax.json.Json;
import javax.json.JsonObject;
import ucd.pacc.compiler.CompilerOptions;
import ucd.pacc.compiler.GraphJsonBuilder;
import ucd.pacc.compiler.StepGraphBuilder;
import ucd.pacc.compiler.Translator;
import ucd.pacc.compiler.TranslatorOptions;
import ucd.pacc.model.StepGraph;
import ucd.pacc.parser.ParseException;
import ucd.pacc.parser.ParseSink;
import ucd.pacc.parser.ParseSource;

public class Compiler
implements Translator {
    private final ParseSource source;
    private final ParseSink sink;
    private final TranslatorOptions options;

    public Compiler(ParseSource source, ParseSink sink, TranslatorOptions options) {
        this.source = source;
        this.source.getClass();
        this.sink = sink;
        this.sink.getClass();
        this.options = options;
        this.options.getClass();
    }

    @Override
    public void translate() throws IOException, ParseException {
        StepGraphBuilder builder = new StepGraphBuilder(this.source);
        StepGraph graph = builder.buildStepGraphFromUserJsonFormat();
        GraphJsonBuilder graphBuilder = new GraphJsonBuilder();
        if (this.options instanceof CompilerOptions) {
            graphBuilder.setComment(((CompilerOptions)this.options).getComment());
        }
        graphBuilder.process(graph);
        JsonObject json = graphBuilder.getJson();
        Writer out = this.sink.getWriter();
        Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", null)).createWriter(out).writeObject(json);
        out.write("\n");
    }
}

