/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.main;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.json.spi.JsonProvider;
import ucd.pacc.decompiler.DecompilerFactory;
import ucd.pacc.http.DeployProcessApi;
import ucd.pacc.http.DeployProcessApiFactory;
import ucd.pacc.http.HttpClientFactory;
import ucd.pacc.main.DownloadProcessCommand;
import ucd.pacc.main.GlobalProcessState;
import ucd.pacc.main.ProcessListFinder;
import ucd.pacc.main.ServerDataGetter;
import ucd.pacc.util.ErrorHandler;
import ucd.pacc.util.IOFactory;

public class DownloadGenericProcessAllMain {
    public static void main(String[] args) {
        String response;
        if (args.length != 4) {
            ErrorHandler.printErrorAndExit("some arguments may be missing or not required. Usage: download-generic-process-all <user-name> <password> <server-url>  output-file-type(json/yml)");
        }
        String username = args[0];
        String password = args[1];
        String url = args[2];
        String outputFileFormat = args[3];
        ServerDataGetter dataGetter = ServerDataGetter.getServerDataGetter(username, password, url);
        try {
            response = dataGetter.getDataFromServer("/cli/process");
        }
        catch (ServerDataGetter.MissingDataException e) {
            throw new RuntimeException(e);
        }
        ProcessListFinder processListFinder = new ProcessListFinder();
        ArrayList<String> processList = processListFinder.getAllProcess(response);
        if (processList.isEmpty()) {
            ErrorHandler.printErrorAndExit("No Process Found in the given Scope");
        }
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
        processList.forEach(process -> executorService.submit(() -> {
            try {
                String[] localArgsIter = new String[]{username, password, url, process, process + "." + outputFileFormat};
                new DownloadProcessCommand(new GlobalProcessState(localArgsIter), new IOFactory(), new HttpClientFactory(), new DeployProcessApiFactory(), JsonProvider.provider(), new DecompilerFactory(), DeployProcessApi::getGenericProcess).execute();
            }
            catch (Exception e) {
                ErrorHandler.printErrorAndExit("Some issue with downloading the process" + process);
            }
        }));
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(300L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executorService.shutdownNow();
        }
    }
}

