/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.analysis;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import ucd.pacc.model.FinishStep;
import ucd.pacc.model.StartStep;
import ucd.pacc.model.Step;
import ucd.pacc.model.StepAction;
import ucd.pacc.model.StepActionFinish;
import ucd.pacc.model.StepGraph;
import ucd.pacc.model.StepName;
import ucd.pacc.parser.OrphanStepException;
import ucd.pacc.parser.ParseException;
import ucd.pacc.util.StepGraphProcessor;

public class CheckNoOrphansProcessor
extends StepGraphProcessor<CheckNoOrphansProcessor> {
    private final Set<StepName> targets = new HashSet<StepName>();

    @Override
    protected CheckNoOrphansProcessor createNestedInstance() {
        return new CheckNoOrphansProcessor();
    }

    @Override
    protected void processStep(Step step) throws ParseException {
        this.collectTargets(step);
    }

    @Override
    protected void processStepGraphEnd(StepGraph graph) throws ParseException {
        for (Step step : graph.getSteps()) {
            StepName name = step.getName();
            if (step instanceof StartStep || step instanceof FinishStep || this.targets.contains(name)) continue;
            throw new OrphanStepException(Optional.of(step.getPosition()), "step can never start: step=" + name.quote());
        }
    }

    protected void collectTargets(Step step) throws ParseException {
        step.getActionStream().filter(action -> !(action instanceof StepActionFinish)).map(StepAction::getTarget).forEach(this.targets::add);
    }
}

