/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.json;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import ucd.pacc.model.AcquireLockStep;
import ucd.pacc.model.ActionContainer;
import ucd.pacc.model.ActionGroup;
import ucd.pacc.model.ActionGroupStep;
import ucd.pacc.model.ActionStep;
import ucd.pacc.model.ActionsOnEvent;
import ucd.pacc.model.AddInventoryStatusStep;
import ucd.pacc.model.AddProcessWarningStep;
import ucd.pacc.model.ApplicationManualTaskStep;
import ucd.pacc.model.ApplicationRunComponentProcessStep;
import ucd.pacc.model.ApplyConfigurationStep;
import ucd.pacc.model.CaseMatch;
import ucd.pacc.model.ComponentManualTaskStep;
import ucd.pacc.model.ComponentRunComponentProcessStep;
import ucd.pacc.model.FinishStep;
import ucd.pacc.model.ForEachAgentStep;
import ucd.pacc.model.ForEachResourceTagStep;
import ucd.pacc.model.GenericManualTaskStep;
import ucd.pacc.model.InstallComponentStep;
import ucd.pacc.model.InstallMultipleComponentsStep;
import ucd.pacc.model.JoinStep;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.PluginStep;
import ucd.pacc.model.ReleaseLockStep;
import ucd.pacc.model.RemoveInventoryStatusStep;
import ucd.pacc.model.RollbackComponentStep;
import ucd.pacc.model.RollbackMultipleComponentsStep;
import ucd.pacc.model.RunGenericProcessForEachAffectedResourceStep;
import ucd.pacc.model.RunGenericProcessStep;
import ucd.pacc.model.RunOperationalProcessForMultipleComponentsStep;
import ucd.pacc.model.RunProcessForEachVersionStep;
import ucd.pacc.model.SetFinalProcessStatusStep;
import ucd.pacc.model.Step;
import ucd.pacc.model.StepActionFinish;
import ucd.pacc.model.StepActionStart;
import ucd.pacc.model.StepGraph;
import ucd.pacc.model.StepName;
import ucd.pacc.model.SwitchStep;
import ucd.pacc.model.UninstallComponentStep;
import ucd.pacc.model.UninstallMultipleComponentsStep;
import ucd.pacc.parser.MissingEdgeSourceException;
import ucd.pacc.parser.MissingEdgeTargetException;
import ucd.pacc.parser.ParseException;
import ucd.pacc.parser.SyntaxException;
import ucd.pacc.parser.analysis.CheckMissingActionTargetProcessor;
import ucd.pacc.parser.analysis.CheckNoCyclesProcessor;
import ucd.pacc.parser.analysis.CheckNoOrphansProcessor;
import ucd.pacc.parser.analysis.CheckPropertyDefinitionDefaultsAgainstPatternsProcessor;
import ucd.pacc.parser.analysis.CheckPropertyDefinitionNameUniquenessProcessor;
import ucd.pacc.parser.analysis.CheckPropertyNameUniquenessProcessor;
import ucd.pacc.parser.analysis.CheckStepAnchorUniquenessProcessor;
import ucd.pacc.parser.analysis.CheckStepNameUniquenessProcessor;
import ucd.pacc.parser.analysis.PopulateStepByAnchorMapProcessor;
import ucd.pacc.parser.analysis.PopulateStepByNameMapProcessor;
import ucd.pacc.parser.json.StepExtractorAcquireLock;
import ucd.pacc.parser.json.StepExtractorAddInventoryStatus;
import ucd.pacc.parser.json.StepExtractorAddProcessWarning;
import ucd.pacc.parser.json.StepExtractorApplicationManualTask;
import ucd.pacc.parser.json.StepExtractorApplicationRunComponentProcess;
import ucd.pacc.parser.json.StepExtractorApplyConfiguration;
import ucd.pacc.parser.json.StepExtractorComponentManualTask;
import ucd.pacc.parser.json.StepExtractorComponentRunComponentProcess;
import ucd.pacc.parser.json.StepExtractorForEachAgent;
import ucd.pacc.parser.json.StepExtractorForEachResourceTag;
import ucd.pacc.parser.json.StepExtractorGenericManualTask;
import ucd.pacc.parser.json.StepExtractorInstallComponent;
import ucd.pacc.parser.json.StepExtractorInstallMultipleComponents;
import ucd.pacc.parser.json.StepExtractorJoin;
import ucd.pacc.parser.json.StepExtractorPlugin;
import ucd.pacc.parser.json.StepExtractorReleaseLock;
import ucd.pacc.parser.json.StepExtractorRemoveInventoryStatus;
import ucd.pacc.parser.json.StepExtractorRollbackComponent;
import ucd.pacc.parser.json.StepExtractorRollbackMultipleComponents;
import ucd.pacc.parser.json.StepExtractorRunGenericProcess;
import ucd.pacc.parser.json.StepExtractorRunGenericProcessForEachAffectedResource;
import ucd.pacc.parser.json.StepExtractorRunOperationalProcessForMultipleComponents;
import ucd.pacc.parser.json.StepExtractorRunProcessForEachVersion;
import ucd.pacc.parser.json.StepExtractorSetFinalProcessStatus;
import ucd.pacc.parser.json.StepExtractorSwitch;
import ucd.pacc.parser.json.StepExtractorUninstallComponent;
import ucd.pacc.parser.json.StepExtractorUninstallMultipleComponents;
import ucd.pacc.util.JsonUtil;
import ucd.pacc.util.ParseExceptionCarrierException;
import ucd.pacc.util.StringParser;
import ucd.pacc.util.Util;

class GraphExtractor {
    private JsonObject json;
    private JsonUtil jsonUtil;
    private StepGraph graph;
    private ParseSourcePosition position;

    GraphExtractor(JsonObject json, ParseSourcePosition position, JsonUtil jsonUtil) {
        this.json = json;
        this.json.getClass();
        this.position = position;
        this.position.getClass();
        this.jsonUtil = jsonUtil;
        this.jsonUtil.getClass();
        this.graph = new StepGraph();
    }

    StepGraph extract() {
        try {
            this.graph.getFinishStep().setName(this.findFinishStepName());
            Stream<Step> steps = Util.concat(this.findPluginSteps(), this.findJoinSteps(), this.findSwitchSteps(), this.findInstallComponentSteps(), this.findRunProcessForEachVersionSteps(), this.findUninstallComponentSteps(), this.findRollbackComponentSteps(), this.findApplyConfigurationSteps(), this.findInstallMultipleComponentsSteps(), this.findUninstallMultipleComponentsSteps(), this.findRollbackMultipleComponentsSteps(), this.findForEachResourceTagSteps(), this.findForEachAgentSteps(), this.findAcquireLockSteps(), this.findReleaseLockSteps(), this.findSetFinalProcessStatusSteps(), this.findAddInventoryStatusSteps(), this.findRemoveInventoryStatusSteps(), this.findAddProcessWarningSteps(), this.findApplicationManualTaskSteps(), this.findComponentManualTaskSteps(), this.findGenericManualTaskSteps(), this.findRunGenericProcessSteps(), this.findComponentRunComponentProcessSteps(), this.findApplicationRunComponentProcessStepsWithoutChangedComponents(), this.findApplicationRunComponentProcessStepsWithChangedComponents(), this.findRunOperationalProcessForMultipleComponentsStepsWithoutChangedComponents(), this.findRunOperationalProcessForMultipleComponentsStepsWithChangedComponents(), this.findRunGenericProcessForEachAffectedResource());
            steps.forEach(this.graph::addStep);
            new CheckStepNameUniquenessProcessor().process(this.graph);
            new CheckStepAnchorUniquenessProcessor().process(this.graph);
            new CheckPropertyNameUniquenessProcessor().process(this.graph);
            new CheckPropertyDefinitionNameUniquenessProcessor().process(this.graph);
            new CheckPropertyDefinitionDefaultsAgainstPatternsProcessor().process(this.graph);
            new PopulateStepByNameMapProcessor().process(this.graph);
            new PopulateStepByAnchorMapProcessor().process(this.graph);
            new CheckMissingActionTargetProcessor().process(this.graph);
            this.findEdges().forEach(this::addEdge);
            new CheckNoOrphansProcessor().process(this.graph);
            new CheckNoCyclesProcessor().process(this.graph);
            return this.graph;
        }
        catch (ParseException e) {
            throw new ParseExceptionCarrierException(e);
        }
    }

    private StepName findFinishStepName() throws ParseException {
        return this.jsonUtil.findUnique((JsonStructure)this.json, "$.children[?(@.type == 'finish')].name").map(this.createParser(StepName::new)).orElseThrow(() -> new SyntaxException(Optional.empty(), "finish step not found"));
    }

    private Stream<PluginStep> findPluginSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'plugin')]").map(this::extractPluginStep);
    }

    private Stream<AcquireLockStep> findAcquireLockSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'acquireLock')]").map(this::extractAcquireLockStep);
    }

    private Stream<ReleaseLockStep> findReleaseLockSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'releaseLock')]").map(this::extractReleaseLockStep);
    }

    private Stream<SetFinalProcessStatusStep> findSetFinalProcessStatusSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'setStatus')]").map(this::extractSetFinalProcessStatusStep);
    }

    private Stream<AddInventoryStatusStep> findAddInventoryStatusSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'addResourceInventory')]").map(this::extractAddInventoryStatusStep);
    }

    private Stream<RemoveInventoryStatusStep> findRemoveInventoryStatusSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'removeResourceInventory')]").map(this::extractRemoveInventoryStatusStep);
    }

    private Stream<AddProcessWarningStep> findAddProcessWarningSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'addWarning')]").map(this::extractAddProcessWarningStep);
    }

    private Stream<ApplicationManualTaskStep> findApplicationManualTaskSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'applicationManualTask')]").map(this::extractApplicationManualTaskStep);
    }

    private Stream<GenericManualTaskStep> findGenericManualTaskSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'manualTask')]").map(this::extractGenericManualTaskStep);
    }

    private Stream<ComponentManualTaskStep> findComponentManualTaskSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'componentManualTask')]").map(this::extractComponentManualTaskStep);
    }

    private Stream<RunGenericProcessStep> findRunGenericProcessSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'runProcess')]").map(this::extractRunGenericProcessStep);
    }

    private Stream<ComponentRunComponentProcessStep> findComponentRunComponentProcessSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'componentProcess')]").map(this::extractComponentRunComponentProcessStep);
    }

    private Stream<ApplicationRunComponentProcessStep> findApplicationRunComponentProcessStepsWithoutChangedComponents() {
        return this.findJsonObjects("$.children[?(@.type == 'componentEnvironmentIterator')]").filter(cei -> this.findUniqueJsonObject((JsonStructure)cei, "$.children[?(@.type == 'componentProcess')]").isPresent()).map(this::extractApplicationRunComponentProcessStepWithoutChangedComponents);
    }

    private Stream<ApplicationRunComponentProcessStep> findApplicationRunComponentProcessStepsWithChangedComponents() {
        return this.findJsonObjects("$.children[?(@.type == 'changedResourceIterator')]").filter(cri -> this.findUniqueJsonObject((JsonStructure)cri, "$.children[?(@.type == 'componentProcess')]").isPresent()).map(this::extractApplicationRunComponentProcessStepWithChangedComponents);
    }

    private Stream<RunOperationalProcessForMultipleComponentsStep> findRunOperationalProcessForMultipleComponentsStepsWithoutChangedComponents() {
        return this.findJsonObjects("$.children[?(@.type == 'multiComponentEnvironmentIterator')]").filter(mci -> this.findUniqueJsonObject((JsonStructure)mci, "$.children[?(@.type == 'componentEnvironmentIterator')]").flatMap(cei -> this.findUniqueJsonObject((JsonStructure)cei, "$.children[?(@.type == 'operationalProcessFilter')]")).flatMap(ivd -> this.findUniqueJsonObject((JsonStructure)ivd, "$.children[?(@.type == 'componentProcess')]")).isPresent()).map(this::extractRunOperationalProcessForMultipleComponentsStepWithoutChangedComponents);
    }

    private Stream<RunOperationalProcessForMultipleComponentsStep> findRunOperationalProcessForMultipleComponentsStepsWithChangedComponents() {
        return this.findJsonObjects("$.children[?(@.type == 'multiComponentEnvironmentIterator')]").filter(mci -> this.findUniqueJsonObject((JsonStructure)mci, "$.children[?(@.type == 'changedResourceIterator')]").flatMap(cei -> this.findUniqueJsonObject((JsonStructure)cei, "$.children[?(@.type == 'operationalProcessFilter')]")).flatMap(ivd -> this.findUniqueJsonObject((JsonStructure)ivd, "$.children[?(@.type == 'componentProcess')]")).isPresent()).map(this::extractRunOperationalProcessForMultipleComponentsStepWithChangedComponents);
    }

    private Stream<RunGenericProcessForEachAffectedResourceStep> findRunGenericProcessForEachAffectedResource() {
        return this.findJsonObjects("$.children[?(@.type == 'touchedResourceIterator')]").filter(cri -> this.findUniqueJsonObject((JsonStructure)cri, "$.children[?(@.type == 'runProcess')]").isPresent()).map(this::extractRunGenericProcessForEachAffectedResourceStep);
    }

    private Stream<JoinStep> findJoinSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'join')]").map(this::extractJoinStep);
    }

    private Stream<SwitchStep> findSwitchSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'switch')]").map(this::extractSwitchStep);
    }

    private Stream<InstallComponentStep> findInstallComponentSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'componentEnvironmentIterator')]").filter(cei -> this.findUniqueJsonObject((JsonStructure)cei, "$.children[?(@.type == 'inventoryVersionDiff')]").flatMap(ivd -> this.findUniqueJsonObject((JsonStructure)ivd, "$.children[?(@.type == 'componentProcess')]")).isPresent()).map(this::extractInstallComponentStep);
    }

    private Stream<RunProcessForEachVersionStep> findRunProcessForEachVersionSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'componentEnvironmentIterator')]").filter(cei -> this.findUniqueJsonObject((JsonStructure)cei, "$.children[?(@.type == 'allVersionsIterator')]").flatMap(ivd -> this.findUniqueJsonObject((JsonStructure)ivd, "$.children[?(@.type == 'componentProcess')]")).isPresent()).map(this::extractRunProcessForEachVersionStep);
    }

    private Stream<RollbackComponentStep> findRollbackComponentSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'componentEnvironmentIterator')]").filter(cei -> this.findUniqueJsonObject((JsonStructure)cei, "$.children[?(@.type == 'uninstallVersionDiff')]").flatMap(ivd -> this.findUniqueJsonObject((JsonStructure)ivd, "$.children[?(@.type == 'componentProcess')]")).isPresent()).map(this::extractRollbackComponentStep);
    }

    private Stream<ApplyConfigurationStep> findApplyConfigurationSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'componentEnvironmentIterator')]").filter(cei -> this.findUniqueJsonObject((JsonStructure)cei, "$.children[?(@.type == 'configurationDiff')]").flatMap(ivd -> this.findUniqueJsonObject((JsonStructure)ivd, "$.children[?(@.type == 'componentProcess')]")).isPresent()).map(this::extractApplyConfigurationStep);
    }

    private Stream<UninstallComponentStep> findUninstallComponentSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'componentEnvironmentIterator')]").filter(cei -> this.findUniqueJsonObject((JsonStructure)cei, "$.children[?(@.type == 'uninstallAllVersionsIterator')]").flatMap(uav -> this.findUniqueJsonObject((JsonStructure)uav, "$.children[?(@.type == 'componentProcess')]")).isPresent()).map(this::extractUninstallComponentStep);
    }

    private Stream<InstallMultipleComponentsStep> findInstallMultipleComponentsSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'multiComponentEnvironmentIterator')]").filter(mci -> this.findUniqueJsonObject((JsonStructure)mci, "$.children[?(@.type == 'componentEnvironmentIterator')]").flatMap(cei -> this.findUniqueJsonObject((JsonStructure)cei, "$.children[?(@.type == 'inventoryVersionDiff')]")).flatMap(ivd -> this.findUniqueJsonObject((JsonStructure)ivd, "$.children[?(@.type == 'componentProcess')]")).isPresent()).map(this::extractInstallMultipleComponentsStep);
    }

    private Stream<UninstallMultipleComponentsStep> findUninstallMultipleComponentsSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'multiComponentEnvironmentIterator')]").filter(mci -> this.findUniqueJsonObject((JsonStructure)mci, "$.children[?(@.type == 'componentEnvironmentIterator')]").flatMap(cei -> this.findUniqueJsonObject((JsonStructure)cei, "$.children[?(@.type == 'uninstallAllVersionsIterator')]")).flatMap(uav -> this.findUniqueJsonObject((JsonStructure)uav, "$.children[?(@.type == 'componentProcess')]")).isPresent()).map(this::extractUninstallMultipleComponentsStep);
    }

    private Stream<RollbackMultipleComponentsStep> findRollbackMultipleComponentsSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'multiComponentEnvironmentIterator')]").filter(mci -> this.findUniqueJsonObject((JsonStructure)mci, "$.children[?(@.type == 'componentEnvironmentIterator')]").flatMap(cei -> this.findUniqueJsonObject((JsonStructure)cei, "$.children[?(@.type == 'uninstallVersionDiff')]")).flatMap(uav -> this.findUniqueJsonObject((JsonStructure)uav, "$.children[?(@.type == 'componentProcess')]")).isPresent()).map(this::extractRollbackMultipleComponentsStep);
    }

    private Stream<ForEachResourceTagStep> findForEachResourceTagSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'eachTagIterator')]").map(this::extractForEachResourceTagStep);
    }

    private Stream<ForEachAgentStep> findForEachAgentSteps() {
        return this.findJsonObjects("$.children[?(@.type == 'eachAgentIterator')]").map(this::extractForEachAgentStep);
    }

    private Stream<JsonObject> findEdges() {
        return this.json.getJsonArray("edges").stream().map(JsonObject.class::cast);
    }

    private void addEdge(JsonObject edge) {
        StepName toStepAnchor = this.parse(StepName::new, edge.getString("to"));
        Optional<StepName> from = Optional.ofNullable(edge.getJsonString("from")).map(JsonString::getString).map(this.createParser(StepName::new));
        String type = edge.getString("type");
        Optional<String> value = Optional.ofNullable(edge.getJsonString("value")).map(JsonString::getString);
        Step toStep = (Step)this.graph.getStepByAnchor(toStepAnchor).orElseThrow(() -> new ParseExceptionCarrierException(new MissingEdgeTargetException(Optional.of(this.position), "missing edge target: step=" + toStepAnchor.quote(), toStepAnchor)));
        if (!from.isPresent()) {
            this.addStartEdge(toStep);
            return;
        }
        StepName fromStepAnchor = from.get();
        Step fromStep = (Step)this.graph.getStepByAnchor(fromStepAnchor).orElseThrow(() -> new ParseExceptionCarrierException(new MissingEdgeSourceException(Optional.of(this.position), "missing edge source: step=" + fromStepAnchor.quote(), fromStepAnchor)));
        if (type.equals("VALUE")) {
            if (!(fromStep instanceof SwitchStep)) {
                throw new ParseExceptionCarrierException(new SyntaxException(Optional.of(this.position), "'VALUE' edge source is not a switch: source=" + fromStep.getName().quote()));
            }
            this.addSwitchEdge((SwitchStep)fromStep, toStep, value);
        } else if (fromStep instanceof ActionStep) {
            this.addStepActionStepEdge((ActionStep)fromStep, toStep);
        } else if (fromStep instanceof ActionGroupStep) {
            this.addActionGroupStepEdge((ActionGroupStep)fromStep, toStep, type);
        } else {
            throw new RuntimeException("unimplemented edge handling for step: type=" + fromStep.getClass().getName());
        }
    }

    private void addStartEdge(Step toStep) {
        this.addStepActionContainerEdge(this.graph.getStartStep(), toStep);
    }

    private void addSwitchEdge(SwitchStep fromStep, Step toStep, Optional<String> value) {
        SwitchStep.SwitchStepCase kase = value.isPresent() && !value.get().isEmpty() ? fromStep.getOrCreateMatchCase(this.createParser(CaseMatch::new).apply(value.get())) : fromStep.getOrCreateDefaultCase();
        this.addStepActionContainerEdge(kase, toStep);
    }

    private void addStepActionStepEdge(ActionStep fromStep, Step toStep) {
        this.addStepActionContainerEdge(fromStep, toStep);
    }

    private void addActionGroupStepEdge(ActionGroupStep fromStep, Step toStep, String type) {
        ActionsOnEvent actionsOnEvent;
        ActionGroup actionGroup = fromStep.getActionGroup();
        switch (type) {
            case "SUCCESS": {
                actionsOnEvent = actionGroup.getOrCreateActionsOnSuccess();
                break;
            }
            case "FAILURE": {
                actionsOnEvent = actionGroup.getOrCreateActionsOnFailure();
                break;
            }
            case "ALWAYS": {
                actionsOnEvent = actionGroup.getOrCreateActionsOnComplete();
                break;
            }
            default: {
                throw new ParseExceptionCarrierException(new SyntaxException(Optional.of(this.position), "unrecognized edge type: type=" + Util.escape(type)));
            }
        }
        this.addStepActionContainerEdge(actionsOnEvent, toStep);
    }

    private void addStepActionContainerEdge(ActionContainer container, Step toStep) {
        if (toStep instanceof FinishStep) {
            container.addAction(new StepActionFinish((FinishStep)toStep));
        } else {
            container.addAction(new StepActionStart(toStep.getName()));
        }
    }

    private PluginStep extractPluginStep(JsonObject object) {
        return new StepExtractorPlugin(this.position, object, this.jsonUtil).extract();
    }

    private JoinStep extractJoinStep(JsonObject object) {
        return new StepExtractorJoin(this.position, object, this.jsonUtil).extract();
    }

    private SwitchStep extractSwitchStep(JsonObject object) {
        return new StepExtractorSwitch(this.position, object, this.jsonUtil).extract();
    }

    private InstallComponentStep extractInstallComponentStep(JsonObject object) {
        return new StepExtractorInstallComponent(this.position, object, this.jsonUtil).extract();
    }

    private RunProcessForEachVersionStep extractRunProcessForEachVersionStep(JsonObject object) {
        return new StepExtractorRunProcessForEachVersion(this.position, object, this.jsonUtil).extract();
    }

    private RollbackComponentStep extractRollbackComponentStep(JsonObject object) {
        return new StepExtractorRollbackComponent(this.position, object, this.jsonUtil).extract();
    }

    private ApplyConfigurationStep extractApplyConfigurationStep(JsonObject object) {
        return new StepExtractorApplyConfiguration(this.position, object, this.jsonUtil).extract();
    }

    private UninstallComponentStep extractUninstallComponentStep(JsonObject object) {
        return new StepExtractorUninstallComponent(this.position, object, this.jsonUtil).extract();
    }

    private InstallMultipleComponentsStep extractInstallMultipleComponentsStep(JsonObject object) {
        return new StepExtractorInstallMultipleComponents(this.position, object, this.jsonUtil).extract();
    }

    private UninstallMultipleComponentsStep extractUninstallMultipleComponentsStep(JsonObject object) {
        return new StepExtractorUninstallMultipleComponents(this.position, object, this.jsonUtil).extract();
    }

    private RollbackMultipleComponentsStep extractRollbackMultipleComponentsStep(JsonObject object) {
        return new StepExtractorRollbackMultipleComponents(this.position, object, this.jsonUtil).extract();
    }

    private ForEachResourceTagStep extractForEachResourceTagStep(JsonObject object) {
        return new StepExtractorForEachResourceTag(this.position, object, this.jsonUtil).extract();
    }

    private ForEachAgentStep extractForEachAgentStep(JsonObject object) {
        return new StepExtractorForEachAgent(this.position, object, this.jsonUtil).extract();
    }

    private AcquireLockStep extractAcquireLockStep(JsonObject object) {
        return new StepExtractorAcquireLock(this.position, object, this.jsonUtil).extract();
    }

    private ReleaseLockStep extractReleaseLockStep(JsonObject object) {
        return new StepExtractorReleaseLock(this.position, object, this.jsonUtil).extract();
    }

    private SetFinalProcessStatusStep extractSetFinalProcessStatusStep(JsonObject object) {
        return new StepExtractorSetFinalProcessStatus(this.position, object, this.jsonUtil).extract();
    }

    private AddInventoryStatusStep extractAddInventoryStatusStep(JsonObject object) {
        return new StepExtractorAddInventoryStatus(this.position, object, this.jsonUtil).extract();
    }

    private RemoveInventoryStatusStep extractRemoveInventoryStatusStep(JsonObject object) {
        return new StepExtractorRemoveInventoryStatus(this.position, object, this.jsonUtil).extract();
    }

    private AddProcessWarningStep extractAddProcessWarningStep(JsonObject object) {
        return new StepExtractorAddProcessWarning(this.position, object, this.jsonUtil).extract();
    }

    private ApplicationManualTaskStep extractApplicationManualTaskStep(JsonObject object) {
        return new StepExtractorApplicationManualTask(this.position, object, this.jsonUtil).extract();
    }

    private ComponentManualTaskStep extractComponentManualTaskStep(JsonObject object) {
        return new StepExtractorComponentManualTask(this.position, object, this.jsonUtil).extract();
    }

    private GenericManualTaskStep extractGenericManualTaskStep(JsonObject object) {
        return new StepExtractorGenericManualTask(this.position, object, this.jsonUtil).extract();
    }

    private RunGenericProcessStep extractRunGenericProcessStep(JsonObject object) {
        return new StepExtractorRunGenericProcess(this.position, object, this.jsonUtil).extract();
    }

    private ComponentRunComponentProcessStep extractComponentRunComponentProcessStep(JsonObject object) {
        return new StepExtractorComponentRunComponentProcess(this.position, object, this.jsonUtil).extract();
    }

    private ApplicationRunComponentProcessStep extractApplicationRunComponentProcessStepWithoutChangedComponents(JsonObject object) {
        return new StepExtractorApplicationRunComponentProcess.WithoutChangedComponents(this.position, object, this.jsonUtil).extract();
    }

    private ApplicationRunComponentProcessStep extractApplicationRunComponentProcessStepWithChangedComponents(JsonObject object) {
        return new StepExtractorApplicationRunComponentProcess.WithChangedComponents(this.position, object, this.jsonUtil).extract();
    }

    private RunOperationalProcessForMultipleComponentsStep extractRunOperationalProcessForMultipleComponentsStepWithoutChangedComponents(JsonObject object) {
        return new StepExtractorRunOperationalProcessForMultipleComponents.WithoutChangedComponents(this.position, object, this.jsonUtil).extract();
    }

    private RunOperationalProcessForMultipleComponentsStep extractRunOperationalProcessForMultipleComponentsStepWithChangedComponents(JsonObject object) {
        return new StepExtractorRunOperationalProcessForMultipleComponents.WithChangedComponents(this.position, object, this.jsonUtil).extract();
    }

    private RunGenericProcessForEachAffectedResourceStep extractRunGenericProcessForEachAffectedResourceStep(JsonObject object) {
        return new StepExtractorRunGenericProcessForEachAffectedResource(this.position, object, this.jsonUtil).extract();
    }

    private Stream<JsonObject> findJsonObjects(String path) {
        JsonArray steps = (JsonArray)this.jsonUtil.find((JsonStructure)this.json, path);
        return steps.stream().map(JsonObject.class::cast);
    }

    private Optional<JsonObject> findUniqueJsonObject(JsonStructure root, String path) {
        JsonValue value;
        JsonArray array = (JsonArray)this.jsonUtil.find(root, path);
        if (array.size() == 1 && (value = (JsonValue)array.get(0)) instanceof JsonObject) {
            return Optional.of((JsonObject)value);
        }
        return Optional.empty();
    }

    private <U> U parse(Function<String, U> ctor, String value) {
        return this.createParser(ctor).apply(value);
    }

    private <U> Function<String, U> createParser(Function<String, U> ctor) {
        return value -> StringParser.parseWithExceptionCarrier(this.position, ctor, value);
    }
}

