/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.http.DeployProcessApi;
import ucd.pacc.main.ProcessMetaData;
import ucd.pacc.main.ProcessType;
import ucd.pacc.util.FileTypeConverter;

public class ProcessDataGetter {
    private final JSONObject processJson;

    ProcessDataGetter(String fileName) {
        this.processJson = this.getProcessJsonFromInputFile(new File(fileName));
    }

    ProcessMetaData getProcessMetaData() {
        ProcessMetaData data = new ProcessMetaData();
        this.setUploadMethod(data);
        return data;
    }

    void setUploadMethod(ProcessMetaData data) {
        if (this.getValueFromJson(ProcessType.APPLICATION.toString().toLowerCase()).isPresent()) {
            data.setProcessType(ProcessType.APPLICATION);
            data.setUploadMethod(DeployProcessApi::putApplicationProcess);
            String parentName = (String)this.getValueFromJson(ProcessType.APPLICATION.toString().toLowerCase()).get();
            data.setParentName(parentName);
        } else if (this.getValueFromJson(ProcessType.COMPONENT.toString().toLowerCase()).isPresent()) {
            data.setProcessType(ProcessType.COMPONENT);
            data.setUploadMethod(DeployProcessApi::putComponentProcess);
            String parentName = (String)this.getValueFromJson(ProcessType.COMPONENT.toString().toLowerCase()).get();
            data.setParentName(parentName);
        } else if (this.getValueFromJson(ProcessType.APPLICATION_TEMPLATE.toString().toLowerCase()).isPresent()) {
            data.setProcessType(ProcessType.APPLICATION_TEMPLATE);
            data.setUploadMethod(DeployProcessApi::putApplicationProcess);
            String parentName = (String)this.getValueFromJson(ProcessType.APPLICATION_TEMPLATE.toString().toLowerCase()).get();
            data.setParentName(parentName);
        } else if (this.getValueFromJson(ProcessType.COMPONENT_TEMPLATE.toString().toLowerCase()).isPresent()) {
            data.setProcessType(ProcessType.COMPONENT_TEMPLATE);
            data.setUploadMethod(DeployProcessApi::putComponentProcess);
            String parentName = (String)this.getValueFromJson(ProcessType.COMPONENT_TEMPLATE.toString().toLowerCase()).get();
            data.setParentName(parentName);
        } else {
            data.setProcessType(ProcessType.GENERIC);
            data.setUploadMethod(DeployProcessApi::putGenericProcess);
        }
        data.setProcessName(this.getMandatoryValueFromJson());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject getProcessJsonFromInputFile(File processFile) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(processFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            if (processFile.toString().contains("yml") || processFile.toString().contains("yaml")) {
                String ymlToJsonString = FileTypeConverter.yamlToJson(new String(Files.readAllBytes(Paths.get(processFile.toString(), new String[0]))));
                JSONObject jSONObject = new JSONObject(ymlToJsonString);
                return jSONObject;
            }
            JSONObject jSONObject = new JSONObject(sb.toString());
            return jSONObject;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read process information from file " + processFile.getAbsolutePath());
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to construct a JSON structure from " + processFile.getName());
        }
    }

    private Optional<Object> getValueFromJson(String key) {
        try {
            return Optional.of(this.processJson.get(key));
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    private String getMandatoryValueFromJson() {
        try {
            return (String)this.processJson.get("process-name");
        }
        catch (JSONException e) {
            throw new RuntimeException("Field process-name not found in input json file");
        }
        catch (Exception e) {
            throw new RuntimeException("Field process-name is expected in String format in input json process file");
        }
    }
}

