/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.main;

import java.io.Reader;
import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import ucd.pacc.main.ProcessMetaData;
import ucd.pacc.main.ProcessType;
import ucd.pacc.main.ServerDataGetter;
import ucd.pacc.util.ErrorHandler;

public class ProcessNameToIdConvertor {
    private final String processName;
    private int processVersion;
    private final ServerDataGetter dataGetter;
    private final ProcessType processType;
    private final ProcessMetaData metaData;

    public ProcessNameToIdConvertor(ProcessMetaData processMetaData, ServerDataGetter dataGetter) {
        this.processName = processMetaData.getProcessName().replaceAll("\\s", "%20");
        this.processType = processMetaData.getProcessType();
        this.metaData = processMetaData;
        this.dataGetter = dataGetter;
    }

    public String getProcessId() {
        String processId = null;
        String urlPre1 = this.getUrlForCommandType();
        try {
            String responseBody = this.dataGetter.getDataFromServer(urlPre1);
            processId = this.getProcessIdFromResponseBody(responseBody);
        }
        catch (ServerDataGetter.MissingDataException e) {
            ErrorHandler.printErrorAndExit("The process may not exist for the " + (Object)((Object)this.processType) + ".\nOr Else the Process name or " + (Object)((Object)this.processType) + " name provided is wrong. Please verify");
        }
        return processId;
    }

    public int getProcessVersion() {
        return this.processVersion;
    }

    private String getProcessIdFromResponseBody(String responseBody) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(responseBody));
        if (this.processType == ProcessType.APPLICATION || this.processType == ProcessType.COMPONENT) {
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject.getString("id");
        }
        if (this.processType == ProcessType.GENERIC || this.processType == ProcessType.APPLICATION_TEMPLATE) {
            JsonArray jsonArray = jsonReader.readArray();
            for (JsonObject jsonObjectNew : jsonArray.getValuesAs(JsonObject.class)) {
                String currentProcessName = jsonObjectNew.getString("name").replaceAll("\\s", "%20");
                if (!currentProcessName.equals(this.processName)) continue;
                String processId = jsonObjectNew.getString("id");
                this.processVersion = jsonObjectNew.getInt("version");
                return processId;
            }
        } else {
            JsonObject jsonObject = jsonReader.readObject();
            JsonArray jsonArray = jsonObject.getJsonArray("processes");
            for (JsonObject jsonObjectNew : jsonArray.getValuesAs(JsonObject.class)) {
                String currentProcessName = jsonObjectNew.getString("name").replaceAll("\\s", "%20");
                if (!currentProcessName.equals(this.processName)) continue;
                String path = jsonObjectNew.getString("path");
                return path.substring(path.lastIndexOf(47) + 1);
            }
            ErrorHandler.printErrorAndExit("Unable to determine the process id for process (" + this.processName + ").\nUser can download or make changes to only existing processes");
        }
        throw new RuntimeException("Unable to determine the process id for " + this.processName + " User can make changes to only existing processes");
    }

    private String getUrlForCommandType() {
        if (this.processType == ProcessType.GENERIC) {
            return this.getGenericProcessUrl();
        }
        if (this.processType == ProcessType.COMPONENT) {
            return this.getComponentProcessUrl(this.metaData.getParentName());
        }
        if (this.processType == ProcessType.COMPONENT_TEMPLATE) {
            return this.getComponentTemplateProcessUrl(this.metaData.getParentName());
        }
        if (this.processType == ProcessType.APPLICATION_TEMPLATE) {
            return this.getApplicationTemplateProcessUrl(this.metaData.getParentName());
        }
        if (this.processType == ProcessType.APPLICATION) {
            return this.getApplicationProcessUrl(this.metaData.getParentName());
        }
        throw new RuntimeException("Invalid commandType");
    }

    private String getApplicationTemplateProcessUrl(String applicationTemplate) {
        String urlPre1 = "/rest/deploy/applicationTemplate/" + applicationTemplate + "/-1/processes";
        return urlPre1;
    }

    private String getComponentTemplateProcessUrl(String componentTemplate) {
        String urlPre1 = "/cli/componentTemplate/export?&componentTemplate=" + componentTemplate;
        return urlPre1;
    }

    private String getApplicationProcessUrl(String applicationName) {
        String urlPre1 = "/cli/applicationProcess/info?application=" + applicationName + "&applicationProcess=" + this.processName;
        return urlPre1;
    }

    private String getComponentProcessUrl(String componentName) {
        String urlPre1 = "/cli/componentProcess/info?component=" + componentName + "&componentProcess=" + this.processName;
        return urlPre1;
    }

    private String getGenericProcessUrl() {
        String urlPre1 = "/cli/process";
        return urlPre1;
    }
}

