/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.main;

import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class Processhandler {
    private final String url;
    private final String dm;
    private final String jsonText;
    private String user;
    private String pwd;

    public Processhandler(String url, String dm, String jsonText, String user, String pwd) {
        this.url = url;
        this.dm = dm;
        this.jsonText = jsonText;
        this.user = user;
        this.pwd = pwd;
    }

    public String createNewProcessAndGetId() {
        CloseableHttpResponse response = this.createProcessAndGetResponseFromServer(this.jsonText);
        String processId = this.getProcessIdFromResponseBody(response.toString());
        return processId;
    }

    private String getProcessIdFromResponseBody(String responseBody) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(responseBody));
        String processId = null;
        JsonObject jsonObject = jsonReader.readObject();
        processId = jsonObject.getString("id");
        return processId;
    }

    private CloseableHttpResponse createProcessAndGetResponseFromServer(String requestBody) {
        CloseableHttpResponse response = null;
        String urlToCreateProcess = this.getUrlForCommandType();
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.user, this.pwd);
        provider.setCredentials(AuthScope.ANY, (Credentials)creds);
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        try {
            sslContextBuilder.loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultCredentialsProvider((CredentialsProvider)provider).build();){
                HttpPut httpPut = new HttpPut(urlToCreateProcess);
                httpPut.addHeader("Content-Type", "application/json");
                StringEntity entity = new StringEntity(requestBody, StandardCharsets.UTF_8);
                httpPut.setEntity((HttpEntity)entity);
                response = httpClient.execute((HttpUriRequest)httpPut);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return response;
    }

    private String getUrlForCommandType() {
        String urlToCreateProcess = "";
        if (this.dm.contains("ComponentProcessMain")) {
            urlToCreateProcess = this.url + "/cli/componentProcess/create";
        }
        urlToCreateProcess = this.dm.contains("ApplicationProcessMain") ? this.url + "/cli/applicationProcess/create" : this.url + "/cli/process/create";
        return urlToCreateProcess;
    }
}

