/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.json;

import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.stream.JsonParsingException;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.StepGraph;
import ucd.pacc.parser.ParseException;
import ucd.pacc.parser.ParseSource;
import ucd.pacc.parser.Parser;
import ucd.pacc.parser.json.GraphExtractor;
import ucd.pacc.util.JsonUtil;
import ucd.pacc.util.ParseExceptionCarrierException;

public class JsonParser
implements Parser {
    @Override
    public StepGraph parse(ParseSource source) throws IOException, ParseException {
        ParseSourcePosition position = new ParseSourcePosition(source.getName(), 1, 1);
        try {
            JsonObject json = Json.createReader((Reader)source.getReader()).readObject();
            JsonUtil jsonUtil = new JsonUtil();
            return new GraphExtractor(json, position, jsonUtil).extract();
        }
        catch (JsonParsingException e) {
            throw new ParseException(Optional.of(position), e.getMessage(), e);
        }
        catch (ParseExceptionCarrierException e) {
            throw e.getCause();
        }
    }
}

