/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.json;

import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import ucd.pacc.model.AbstractManualTaskStep;
import ucd.pacc.model.AnyUserTaskApprovalRestriction;
import ucd.pacc.model.CheckboxPropertyDefinitionOptions;
import ucd.pacc.model.DateTimePropertyDefinitionOptions;
import ucd.pacc.model.DeployingUserTaskApprovalRestriction;
import ucd.pacc.model.MultiSelectPropertyDefinitionOptions;
import ucd.pacc.model.NotificationTemplateName;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.PropertyDefinition;
import ucd.pacc.model.PropertyDefinitionOptions;
import ucd.pacc.model.PropertyDefinitionType;
import ucd.pacc.model.PropertyDescription;
import ucd.pacc.model.PropertyExpression;
import ucd.pacc.model.PropertyLabel;
import ucd.pacc.model.PropertyName;
import ucd.pacc.model.PropertyPattern;
import ucd.pacc.model.ResourceTypeName;
import ucd.pacc.model.RoleBasedTaskApprovalRestriction;
import ucd.pacc.model.RoleBasedTaskApprovalType;
import ucd.pacc.model.RoleName;
import ucd.pacc.model.RoleRestriction;
import ucd.pacc.model.SecurePropertyDefinitionOptions;
import ucd.pacc.model.SelectPropertyDefinitionOptions;
import ucd.pacc.model.SelectPropertyValue;
import ucd.pacc.model.TaskApprovalRestriction;
import ucd.pacc.model.TextAreaPropertyDefinitionOptions;
import ucd.pacc.model.TextPropertyDefinitionOptions;
import ucd.pacc.parser.json.StepExtractor;
import ucd.pacc.util.JsonUtil;
import ucd.pacc.util.Util;

abstract class StepExtractorAbstractManualTask<T extends AbstractManualTaskStep>
extends StepExtractor<T> {
    StepExtractorAbstractManualTask(ParseSourcePosition position, JsonObject object, String context, JsonUtil jsonUtil) {
        super(position, object, context, jsonUtil);
    }

    protected void configureStep(T step) {
        ((AbstractManualTaskStep)step).setNotificationTemplate(this.getNotificationTemplate());
        ((AbstractManualTaskStep)step).setApprovalRestriction(this.getApprovalRestriction());
        this.findPropertyDefinitions().forEach(arg_0 -> step.addPropertyDefinition(arg_0));
    }

    protected Optional<NotificationTemplateName> getNotificationTemplate() {
        return this.findString(new StepExtractor.JsonKey("templateName"), BASE).filter(Util::isNotEmpty).map(this.createParser(NotificationTemplateName::new));
    }

    protected TaskApprovalRestriction getApprovalRestriction() {
        Optional<Boolean> deployingUserOnly = this.findBoolean(new StepExtractor.JsonKey("deployingUserOnly"), BASE);
        if (deployingUserOnly.isPresent() && deployingUserOnly.get().booleanValue()) {
            return new DeployingUserTaskApprovalRestriction();
        }
        Optional<String> contextType = this.findString(new StepExtractor.JsonKey("contextType"), new StepExtractor.JsonPath("$.roleRestrictionData"));
        if (!contextType.isPresent()) {
            return new AnyUserTaskApprovalRestriction();
        }
        RoleBasedTaskApprovalType approvalType = this.parse(RoleBasedTaskApprovalType::getForJsonKeyword, contextType.get());
        RoleBasedTaskApprovalRestriction approvalRestriction = new RoleBasedTaskApprovalRestriction(approvalType);
        this.findRoleRestrictions().forEach(approvalRestriction::addRestriction);
        return approvalRestriction;
    }

    protected Stream<RoleRestriction> findRoleRestrictions() {
        return Optional.ofNullable(this.object.getJsonObject("roleRestrictionData")).flatMap(o -> Optional.ofNullable(o.getJsonArray("roleRestrictions"))).map(Collection::stream).orElse(Stream.empty()).flatMap(Util.asInstanceofStream(JsonObject.class)).flatMap(this::extractRoleRestriction);
    }

    protected Stream<RoleRestriction> extractRoleRestriction(JsonObject roleRestriction) {
        Optional<RoleName> role = this.findRole(roleRestriction);
        Optional<ResourceTypeName> resourceType = this.findResourceType(roleRestriction);
        return role.map(RoleRestriction::new).map(rr -> {
            rr.setResourceType(resourceType);
            return rr;
        }).map(Stream::of).orElse(Stream.empty());
    }

    protected Optional<RoleName> findRole(JsonObject roleRestriction) {
        Optional<RoleName> role = this.getProperty(roleRestriction, RoleName::new, "roleName");
        if (!role.isPresent()) {
            role = this.getProperty(roleRestriction, RoleName::new, "roleId");
        }
        return role;
    }

    protected Optional<ResourceTypeName> findResourceType(JsonObject roleRestriction) {
        Optional<ResourceTypeName> resourceTypeName = this.getProperty(roleRestriction, ResourceTypeName::new, "resourceRoleName");
        if (!resourceTypeName.isPresent()) {
            resourceTypeName = this.getProperty(roleRestriction, ResourceTypeName::new, "resourceRoleId");
        }
        return resourceTypeName;
    }

    protected Stream<PropertyDefinition> findPropertyDefinitions() {
        return Optional.ofNullable(this.object.getJsonArray("propDefs")).map(Collection::stream).orElse(Stream.empty()).flatMap(Util.asInstanceofStream(JsonObject.class)).flatMap(this::extractPropertyDefinition);
    }

    protected Stream<PropertyDefinition> extractPropertyDefinition(JsonObject jsonPropdef) {
        Optional<PropertyName> name = this.getName(jsonPropdef);
        Optional<PropertyDefinitionType> type = this.getType(jsonPropdef);
        if (!name.isPresent() || !type.isPresent()) {
            return Stream.empty();
        }
        PropertyDefinition value = new PropertyDefinition(type.get(), name.get());
        value.setOptions(Optional.of(this.extractPropertyDefinitionOptions(value, jsonPropdef)));
        return Stream.of(value);
    }

    protected PropertyDefinitionOptions extractPropertyDefinitionOptions(PropertyDefinition propdef, JsonObject jsonPropdef) {
        PropertyDefinitionType type = propdef.getType();
        switch (type) {
            case TEXT: {
                return this.extractTextPropertyDefinitionOptions(jsonPropdef);
            }
            case TEXT_AREA: {
                return this.extractTextAreaPropertyDefinitionOptions(jsonPropdef);
            }
            case SECURE: {
                return this.extractSecurePropertyDefinitionOptions(jsonPropdef);
            }
            case CHECKBOX: {
                return this.extractCheckboxPropertyDefinitionOptions(jsonPropdef);
            }
            case DATE_TIME: {
                return this.extractDateTimePropertyDefinitionOptions(jsonPropdef);
            }
            case SELECT: {
                return this.extractSelectPropertyDefinitionOptions(jsonPropdef);
            }
            case MULTI_SELECT: {
                return this.extractMultiSelectPropertyDefinitionOptions(jsonPropdef);
            }
        }
        throw new RuntimeException("unimplemented property definition type: " + type);
    }

    protected TextPropertyDefinitionOptions extractTextPropertyDefinitionOptions(JsonObject jsonPropdef) {
        TextPropertyDefinitionOptions options = new TextPropertyDefinitionOptions();
        this.configureCommonOptions(options, jsonPropdef);
        options.setDefaultValue((Optional)this.getPropertyExpressionDefaultValue(jsonPropdef));
        return options;
    }

    protected TextAreaPropertyDefinitionOptions extractTextAreaPropertyDefinitionOptions(JsonObject jsonPropdef) {
        TextAreaPropertyDefinitionOptions options = new TextAreaPropertyDefinitionOptions();
        this.configureCommonOptions(options, jsonPropdef);
        options.setDefaultValue((Optional)this.getPropertyExpressionDefaultValue(jsonPropdef));
        return options;
    }

    protected SecurePropertyDefinitionOptions extractSecurePropertyDefinitionOptions(JsonObject jsonPropdef) {
        SecurePropertyDefinitionOptions options = new SecurePropertyDefinitionOptions();
        options.setLabel((Optional)this.getLabel(jsonPropdef));
        options.setDescription((Optional)this.getDescription(jsonPropdef));
        options.setRequired(this.getRequired(jsonPropdef));
        options.setDefaultValue((Optional)this.getPropertyExpressionDefaultValue(jsonPropdef));
        return options;
    }

    protected CheckboxPropertyDefinitionOptions extractCheckboxPropertyDefinitionOptions(JsonObject jsonPropdef) {
        CheckboxPropertyDefinitionOptions options = new CheckboxPropertyDefinitionOptions();
        this.configureCommonOptions(options, jsonPropdef);
        options.setDefaultValue(this.getCheckboxDefaultValue(jsonPropdef));
        return options;
    }

    protected DateTimePropertyDefinitionOptions extractDateTimePropertyDefinitionOptions(JsonObject jsonPropdef) {
        DateTimePropertyDefinitionOptions options = new DateTimePropertyDefinitionOptions();
        this.configureCommonOptions(options, jsonPropdef);
        options.setDefaultValue(this.getDateTimeDefaultValue(jsonPropdef));
        return options;
    }

    protected SelectPropertyDefinitionOptions extractSelectPropertyDefinitionOptions(JsonObject jsonPropdef) {
        SelectPropertyDefinitionOptions options = new SelectPropertyDefinitionOptions();
        this.configureCommonOptions(options, jsonPropdef);
        this.findAllowedValues(jsonPropdef).forEach(options::addValue);
        this.configureSelectDefaultValue(options, jsonPropdef);
        return options;
    }

    protected MultiSelectPropertyDefinitionOptions extractMultiSelectPropertyDefinitionOptions(JsonObject jsonPropdef) {
        MultiSelectPropertyDefinitionOptions options = new MultiSelectPropertyDefinitionOptions();
        this.configureCommonOptions(options, jsonPropdef);
        this.findAllowedValues(jsonPropdef).forEach(options::addValue);
        this.configureMultiSelectDefaultValues(options, jsonPropdef);
        return options;
    }

    protected void configureSelectDefaultValue(SelectPropertyDefinitionOptions options, JsonObject jsonPropdef) {
        options.setDefaultValue(this.getSelectPropertyValueValue(jsonPropdef));
    }

    protected void configureMultiSelectDefaultValues(MultiSelectPropertyDefinitionOptions options, JsonObject jsonPropdef) {
        this.getProperty(jsonPropdef, this::splitOnCommas, "value").orElse(Stream.empty()).map(this.createParser(SelectPropertyValue::new)).forEach(options::addDefaultValue);
    }

    protected Stream<SelectPropertyValue> findAllowedValues(JsonObject jsonPropdef) {
        return Optional.ofNullable(jsonPropdef.getJsonArray("allowedValues")).map(Collection::stream).orElse(Stream.empty()).flatMap(Util.asInstanceofStream(JsonObject.class)).flatMap(this::extractSelectPropertyValue);
    }

    protected Stream<SelectPropertyValue> extractSelectPropertyValue(JsonObject selectPropertyValue) {
        Optional<SelectPropertyValue> value = this.getSelectPropertyValueValue(selectPropertyValue);
        Optional<PropertyLabel> label = this.getSelectPropertyValueLabel(selectPropertyValue);
        value.ifPresent(v -> v.setLabel(label));
        return value.map(Stream::of).orElse(Stream.empty());
    }

    protected Optional<PropertyLabel> getSelectPropertyValueLabel(JsonObject propdef) {
        return this.getProperty(propdef, PropertyLabel::new, "label");
    }

    protected Optional<SelectPropertyValue> getSelectPropertyValueValue(JsonObject propdef) {
        return this.getProperty(propdef, SelectPropertyValue::new, "value");
    }

    protected void configureCommonOptions(PropertyDefinitionOptions options, JsonObject jsonPropdef) {
        options.setLabel(this.getLabel(jsonPropdef));
        options.setDescription(this.getDescription(jsonPropdef));
        options.setPattern(this.getPattern(jsonPropdef));
        options.setRequired(this.getRequired(jsonPropdef));
    }

    protected Optional<PropertyExpression> getPropertyExpressionDefaultValue(JsonObject propdef) {
        return this.getProperty(propdef, PropertyExpression::new, "value");
    }

    protected Optional<Instant> getDateTimeDefaultValue(JsonObject propdef) {
        return this.getProperty(propdef, Long::parseLong, "value").map(Instant::ofEpochMilli);
    }

    protected boolean getCheckboxDefaultValue(JsonObject propdef) {
        return this.getProperty(propdef, Boolean::parseBoolean, "value").orElse(false);
    }

    protected Optional<PropertyName> getName(JsonObject propdef) {
        return this.getProperty(propdef, PropertyName::new, "name");
    }

    protected Optional<PropertyDefinitionType> getType(JsonObject propdef) {
        return this.getProperty(propdef, PropertyDefinitionType::getForJsonKeyword, "type");
    }

    protected Optional<PropertyLabel> getLabel(JsonObject propdef) {
        return this.getProperty(propdef, PropertyLabel::new, "label");
    }

    protected Optional<PropertyPattern> getPattern(JsonObject propdef) {
        return this.getProperty(propdef, PropertyPattern::new, "pattern");
    }

    protected Optional<PropertyDescription> getDescription(JsonObject propdef) {
        return this.getProperty(propdef, PropertyDescription::new, "description");
    }

    protected <U> Optional<U> getProperty(JsonObject object, Function<String, U> parser, String fieldName) {
        return this.jsonUtil.findUnique((JsonStructure)object, "$." + fieldName, String.class).filter(Util::isNotEmpty).map(parser);
    }

    protected boolean getRequired(JsonObject propdef) {
        return this.jsonUtil.findUnique((JsonStructure)propdef, "$.required", Boolean.class).orElse(false);
    }
}

