/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.json;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonObject;
import javax.json.JsonString;
import ucd.pacc.model.CommentPrompt;
import ucd.pacc.model.DeployingUserTaskApprovalRestriction;
import ucd.pacc.model.GenericManualTaskStep;
import ucd.pacc.model.GroupName;
import ucd.pacc.model.IdentityBasedTaskApprovalRestriction;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.TaskApprovalRestriction;
import ucd.pacc.model.UserName;
import ucd.pacc.parser.json.StepExtractorAbstractManualTask;
import ucd.pacc.util.JsonUtil;
import ucd.pacc.util.Util;

class StepExtractorGenericManualTask
extends StepExtractorAbstractManualTask<GenericManualTaskStep> {
    StepExtractorGenericManualTask(ParseSourcePosition position, JsonObject object, JsonUtil jsonUtil) {
        super(position, object, "generic manual task step", jsonUtil);
    }

    @Override
    public GenericManualTaskStep extract() {
        GenericManualTaskStep step = new GenericManualTaskStep(this.position, this.getStepName());
        this.configureStep(step);
        step.setCommentRequired(this.getCommentRequired());
        step.setCommentPrompt(this.getCommentPrompt());
        return step;
    }

    @Override
    protected TaskApprovalRestriction getApprovalRestriction() {
        if (this.getBoolean("deployingUserOnly")) {
            return new DeployingUserTaskApprovalRestriction();
        }
        IdentityBasedTaskApprovalRestriction approvalRestriction = new IdentityBasedTaskApprovalRestriction();
        this.getCommaSeparatedList("userNames", UserName::new).forEach(approvalRestriction::addUser);
        this.getCommaSeparatedList("groupNames", GroupName::new).forEach(approvalRestriction::addGroup);
        return approvalRestriction;
    }

    protected <T> Stream<T> getCommaSeparatedList(String key, Function<String, T> ctor) {
        return Optional.ofNullable(this.object.getJsonString(key)).map(JsonString::getString).map(this::splitOnCommas).orElse(Stream.empty()).map(this.createParser(ctor));
    }

    protected boolean getCommentRequired() {
        return this.getBoolean("commentRequired");
    }

    protected boolean getBoolean(String key) {
        return this.object.containsKey((Object)key) && this.object.getBoolean(key);
    }

    protected Optional<CommentPrompt> getCommentPrompt() {
        return Optional.ofNullable(this.object.getJsonString("commentPrompt")).map(JsonString::getString).filter(Util::isNotEmpty).map(this.createParser(CommentPrompt::new));
    }
}

