/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.json;

import java.util.Optional;
import javax.json.JsonObject;
import ucd.pacc.model.ChangedComponentResourceSelectionMode;
import ucd.pacc.model.ChangedComponentResourceTagSelection;
import ucd.pacc.model.ComponentTagName;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.ResourceTagName;
import ucd.pacc.model.RunOperationalProcessForMultipleComponentsStep;
import ucd.pacc.model.StepName;
import ucd.pacc.parser.json.StepExtractor;
import ucd.pacc.parser.json.StepExtractorAppProcess;
import ucd.pacc.util.JsonUtil;
import ucd.pacc.util.Util;

abstract class StepExtractorRunOperationalProcessForMultipleComponents
extends StepExtractorAppProcess<RunOperationalProcessForMultipleComponentsStep> {
    public StepExtractorRunOperationalProcessForMultipleComponents(ParseSourcePosition position, JsonObject object, JsonUtil jsonUtil) {
        super(position, object, "run operation process for multiple components step", jsonUtil);
    }

    @Override
    public RunOperationalProcessForMultipleComponentsStep extract() {
        RunOperationalProcessForMultipleComponentsStep step = new RunOperationalProcessForMultipleComponentsStep(this.position, this.getStepName(), this.getProcessName());
        this.configureStep(step);
        step.setByComponentTag(this.getByComponentTag());
        step.setByChangedComponent(this.getByChangedComponent());
        this.getMaxConcurrentComponents().ifPresent(step::setMaxConcurrentComponents);
        return step;
    }

    @Override
    protected StepName getStepName() {
        return this.parse(StepName::new, this.mustFindString(new StepExtractor.JsonKey("name"), new StepExtractor.JsonPath("$.children[?(@.type == '" + this.getOperationalProcessFilterContainerType() + "')].children[?(@.type == 'operationalProcessFilter')].children[?(@.type == 'componentProcess')]")));
    }

    @Override
    protected Optional<ResourceTagName> getByResourceTag() {
        return this.findString(new StepExtractor.JsonKey("tagId"), new StepExtractor.JsonPath("$.children[?(@.type == '" + this.getOperationalProcessFilterContainerType() + "')]")).filter(Util::isNotEmpty).map(this.createParser(ResourceTagName::new));
    }

    protected abstract Optional<ChangedComponentResourceTagSelection> getByChangedComponent();

    protected abstract String getOperationalProcessFilterContainerType();

    static class WithChangedComponents
    extends StepExtractorRunOperationalProcessForMultipleComponents {
        WithChangedComponents(ParseSourcePosition position, JsonObject object, JsonUtil jsonUtil) {
            super(position, object, jsonUtil);
        }

        @Override
        protected Optional<ChangedComponentResourceTagSelection> getByChangedComponent() {
            ChangedComponentResourceTagSelection result = new ChangedComponentResourceTagSelection(this.getSelectionMode());
            result.setByComponentTag(this.getMonitoredComponentTag());
            return Optional.of(result);
        }

        @Override
        protected String getOperationalProcessFilterContainerType() {
            return "changedResourceIterator";
        }

        private ChangedComponentResourceSelectionMode getSelectionMode() {
            return this.parse(ChangedComponentResourceSelectionMode::getForJsonKeyword, this.mustFindString(new StepExtractor.JsonKey("resourceSelectionMode"), new StepExtractor.JsonPath("$.children[?(@.type == 'changedResourceIterator')]")));
        }

        private Optional<ComponentTagName> getMonitoredComponentTag() {
            return this.findString(new StepExtractor.JsonKey("monitorTag"), new StepExtractor.JsonPath("$.children[?(@.type == 'changedResourceIterator')]")).filter(Util::isNotEmpty).map(this.createParser(ComponentTagName::new));
        }
    }

    static class WithoutChangedComponents
    extends StepExtractorRunOperationalProcessForMultipleComponents {
        WithoutChangedComponents(ParseSourcePosition position, JsonObject object, JsonUtil jsonUtil) {
            super(position, object, jsonUtil);
        }

        @Override
        protected Optional<ChangedComponentResourceTagSelection> getByChangedComponent() {
            return Optional.empty();
        }

        @Override
        protected String getOperationalProcessFilterContainerType() {
            return "componentEnvironmentIterator";
        }
    }
}

