/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.decompiler;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import ucd.pacc.decompiler.SelectPropertyValueWithSelectedFlag;
import ucd.pacc.model.SelectPropertyValue;

class DefaultValueSelector {
    private final Set<SelectPropertyValue> defaultValues;

    DefaultValueSelector(Optional<SelectPropertyValue> defaultValue) {
        defaultValue.getClass();
        this.defaultValues = defaultValue.map(Collections::singleton).orElse(Collections.emptySet());
    }

    DefaultValueSelector(Collection<SelectPropertyValue> defaultValues) {
        defaultValues.getClass();
        this.defaultValues = Collections.unmodifiableSet(new HashSet<SelectPropertyValue>(defaultValues));
        this.defaultValues.forEach(Object::getClass);
    }

    public SelectPropertyValueWithSelectedFlag selectIfDefault(SelectPropertyValueWithSelectedFlag value) {
        value.setSelected(this.defaultValues.contains(value.getValue()));
        return value;
    }
}

