/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.main;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import ucd.pacc.main.BadArgumentException;
import ucd.pacc.main.GlobalProcessState;
import ucd.pacc.main.ProgramInfo;
import ucd.pacc.parser.ParseException;
import ucd.pacc.util.IOFactory;

abstract class AbstractCommand {
    private final GlobalProcessState globalProcessState;
    private final IOFactory ioFactory;
    private final Charset charset;

    AbstractCommand(GlobalProcessState globalProcessState, IOFactory ioFactory) {
        this.globalProcessState = globalProcessState;
        this.globalProcessState.getClass();
        this.ioFactory = ioFactory;
        this.ioFactory.getClass();
        this.charset = Charset.forName("UTF-8");
    }

    public void execute() {
        try {
            this.printProgramInfo();
            this.parseArguments();
            this.doCommand();
        }
        catch (ParseException e) {
            this.handleException(e, "Parse error");
        }
        catch (IOException e) {
            this.handleException(e, "IO error");
        }
        catch (GeneralSecurityException e) {
            this.handleException(e, "Encryption error");
        }
        catch (BadArgumentException e) {
            this.handleException(e, "Bad command-line argument");
        }
    }

    protected void handleException(Exception cause, String message) {
        GlobalProcessState gps = this.getGlobalProcessState();
        PrintStream stderr = gps.getStderr();
        stderr.println(message + ": " + cause.getMessage());
        if (this.isDebug()) {
            cause.printStackTrace(stderr);
        }
        gps.exit(1);
    }

    protected abstract void doCommand() throws ParseException, IOException, GeneralSecurityException;

    protected abstract void parseArguments() throws BadArgumentException;

    protected GlobalProcessState getGlobalProcessState() {
        return this.globalProcessState;
    }

    protected IOFactory getIOFactory() {
        return this.ioFactory;
    }

    protected Charset getCharset() {
        return this.charset;
    }

    protected boolean isDebug() {
        return this.getGlobalProcessState().getEnvironment().isDebug();
    }

    protected void printProgramInfo() {
        GlobalProcessState gps = this.getGlobalProcessState();
        if (this.isDebug()) {
            PrintStream stderr = gps.getStderr();
            ProgramInfo info = gps.getProgramInfo();
            stderr.printf("program=%s%n", info.getName());
            stderr.printf("version=%s%n", info.getVersion());
            stderr.printf("location=%s%n", info.getLocation());
            stderr.printf("workdir=%s%n", gps.getWorkingDirectory());
        }
    }
}

