/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import java.util.Optional;
import ucd.pacc.model.CommonPropertyDefinitionOptions;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.PropertyDefinition;
import ucd.pacc.model.PropertyDefinitionOptions;
import ucd.pacc.model.PropertyDescription;
import ucd.pacc.model.PropertyLabel;
import ucd.pacc.model.PropertyPattern;
import ucd.pacc.model.Step;
import ucd.pacc.parser.ParseException;
import ucd.pacc.parser.PropertyDefinitionDefaultViolatesPatternException;
import ucd.pacc.util.Util;

abstract class AbstractPropertyDefinitionOptions
implements PropertyDefinitionOptions {
    private Optional<CommonPropertyDefinitionOptions> commonOptions = Optional.empty();

    protected AbstractPropertyDefinitionOptions() {
    }

    @Override
    public Optional<CommonPropertyDefinitionOptions> getCommonOptions() {
        return this.commonOptions;
    }

    @Override
    public void setCommonOptions(Optional<CommonPropertyDefinitionOptions> commonOptions) {
        commonOptions.getClass();
        this.commonOptions = commonOptions;
    }

    protected CommonPropertyDefinitionOptions getOrCreateCommonOptions() {
        Optional<CommonPropertyDefinitionOptions> options = this.getCommonOptions();
        if (!options.isPresent()) {
            options = Optional.of(new CommonPropertyDefinitionOptions());
            this.setCommonOptions(options);
        }
        return options.get();
    }

    @Override
    public Optional<PropertyLabel> getLabel() {
        return this.commonOptions.flatMap(CommonPropertyDefinitionOptions::getLabel);
    }

    @Override
    public void setLabel(Optional<PropertyLabel> label) {
        this.getOrCreateCommonOptions().setLabel(label);
    }

    @Override
    public Optional<PropertyDescription> getDescription() {
        return this.commonOptions.flatMap(CommonPropertyDefinitionOptions::getDescription);
    }

    @Override
    public void setDescription(Optional<PropertyDescription> description) {
        this.getOrCreateCommonOptions().setDescription(description);
    }

    @Override
    public boolean isRequired() {
        return this.commonOptions.map(CommonPropertyDefinitionOptions::isRequired).orElse(false);
    }

    @Override
    public void setRequired(boolean required) {
        this.getOrCreateCommonOptions().setRequired(required);
    }

    @Override
    public Optional<PropertyPattern> getPattern() {
        return this.commonOptions.flatMap(CommonPropertyDefinitionOptions::getPattern);
    }

    @Override
    public void setPattern(Optional<PropertyPattern> pattern) {
        this.getOrCreateCommonOptions().setPattern(pattern);
    }

    protected void checkDefaultValueAgainstPattern(Step step, PropertyDefinition propertyDefinition, Optional<String> value) throws ParseException {
        Optional<PropertyPattern> pattern = this.getPattern();
        if (value.isPresent() && pattern.isPresent()) {
            String v = value.get();
            PropertyPattern p = pattern.get();
            if (!p.matches(v)) {
                ParseSourcePosition position = propertyDefinition.getPosition().orElse(step.getPosition());
                throw new PropertyDefinitionDefaultViolatesPatternException(Optional.of(position), String.format("property definition default does not match pattern: step=%s propdef=%s pattern=%s default=%s", step.getName().quote(), propertyDefinition.getName().quote(), p.quote(), Util.quote(v)));
            }
        }
    }
}

