/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import ucd.pacc.util.Util;

public abstract class Concurrency {
    private static final Unlimited UNLIMITED = new Unlimited();

    public static Concurrency createFromPacString(String unlimitedOrPositiveInt) {
        if (unlimitedOrPositiveInt.equals("unlimited")) {
            return Concurrency.unlimited();
        }
        return Concurrency.limited(Integer.parseInt(unlimitedOrPositiveInt));
    }

    public static Concurrency createFromJsonString(String integer) {
        try {
            int val = Integer.parseInt(integer);
            if (val == -1) {
                return Concurrency.unlimited();
            }
            if (val > 0) {
                return Concurrency.limited(val);
            }
            throw new IllegalArgumentException("concurrency is not unlimited or positive integer: value=" + integer);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("concurrency is invalid: value=" + Util.quote(integer), e);
        }
    }

    public static Concurrency unlimited() {
        return UNLIMITED;
    }

    public static Concurrency limited(int value) {
        return new Limited(value);
    }

    private Concurrency() {
    }

    public abstract int getValue();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Concurrency)) {
            return false;
        }
        return this.getEssence().equals(((Concurrency)obj).getEssence());
    }

    public abstract int hashCode();

    protected abstract Object getEssence();

    private static class Limited
    extends Concurrency {
        final int value;

        private Limited(int value) {
            if (value <= 0) {
                throw new IllegalArgumentException("concurrency is not a positive integer: value=" + value);
            }
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.value);
        }

        @Override
        protected Object getEssence() {
            return this.value;
        }
    }

    private static class Unlimited
    extends Concurrency {
        private Unlimited() {
        }

        @Override
        public int getValue() {
            return -1;
        }

        public String toString() {
            return "unlimited";
        }

        @Override
        public int hashCode() {
            return 183923801;
        }

        @Override
        protected Object getEssence() {
            return this;
        }
    }
}

