/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import ucd.pacc.model.CheckboxPropertyDefinitionOptions;
import ucd.pacc.model.DateTimePropertyDefinitionOptions;
import ucd.pacc.model.ModelValueEnum;
import ucd.pacc.model.MultiSelectPropertyDefinitionOptions;
import ucd.pacc.model.PropertyDefinitionOptions;
import ucd.pacc.model.SecurePropertyDefinitionOptions;
import ucd.pacc.model.SelectPropertyDefinitionOptions;
import ucd.pacc.model.TextAreaPropertyDefinitionOptions;
import ucd.pacc.model.TextPropertyDefinitionOptions;

public enum PropertyDefinitionType implements ModelValueEnum
{
    TEXT{

        @Override
        public String getJsonKeyword() {
            return "TEXT";
        }

        @Override
        public String getPacKeyword() {
            return "text";
        }

        @Override
        public boolean isOptionsCompatible(PropertyDefinitionOptions options) {
            return options instanceof TextPropertyDefinitionOptions;
        }

        @Override
        public String getPacOptionsKeyword() {
            return "with";
        }
    }
    ,
    TEXT_AREA{

        @Override
        public String getJsonKeyword() {
            return "TEXTAREA";
        }

        @Override
        public String getPacKeyword() {
            return "text-area";
        }

        @Override
        public boolean isOptionsCompatible(PropertyDefinitionOptions options) {
            return options instanceof TextAreaPropertyDefinitionOptions;
        }

        @Override
        public String getPacOptionsKeyword() {
            return "with";
        }
    }
    ,
    SECURE{

        @Override
        public String getJsonKeyword() {
            return "SECURE";
        }

        @Override
        public String getPacKeyword() {
            return "secure";
        }

        @Override
        public boolean isOptionsCompatible(PropertyDefinitionOptions options) {
            return options instanceof SecurePropertyDefinitionOptions;
        }

        @Override
        public String getPacOptionsKeyword() {
            return "with";
        }
    }
    ,
    CHECKBOX{

        @Override
        public String getJsonKeyword() {
            return "CHECKBOX";
        }

        @Override
        public String getPacKeyword() {
            return "checkbox";
        }

        @Override
        public boolean isOptionsCompatible(PropertyDefinitionOptions options) {
            return options instanceof CheckboxPropertyDefinitionOptions;
        }

        @Override
        public String getPacOptionsKeyword() {
            return "with";
        }
    }
    ,
    SELECT{

        @Override
        public String getJsonKeyword() {
            return "SELECT";
        }

        @Override
        public String getPacKeyword() {
            return "select";
        }

        @Override
        public boolean isOptionsCompatible(PropertyDefinitionOptions options) {
            return options instanceof SelectPropertyDefinitionOptions;
        }

        @Override
        public String getPacOptionsKeyword() {
            return "of";
        }
    }
    ,
    MULTI_SELECT{

        @Override
        public String getJsonKeyword() {
            return "MULTI_SELECT";
        }

        @Override
        public String getPacKeyword() {
            return "multi-select";
        }

        @Override
        public boolean isOptionsCompatible(PropertyDefinitionOptions options) {
            return options instanceof MultiSelectPropertyDefinitionOptions;
        }

        @Override
        public String getPacOptionsKeyword() {
            return "of";
        }
    }
    ,
    DATE_TIME{

        @Override
        public String getJsonKeyword() {
            return "DATETIME";
        }

        @Override
        public String getPacKeyword() {
            return "date-time";
        }

        @Override
        public boolean isOptionsCompatible(PropertyDefinitionOptions options) {
            return options instanceof DateTimePropertyDefinitionOptions;
        }

        @Override
        public String getPacOptionsKeyword() {
            return "with";
        }
    };


    public abstract boolean isOptionsCompatible(PropertyDefinitionOptions var1);

    public abstract String getPacOptionsKeyword();

    public static PropertyDefinitionType getForPacKeyword(String text) {
        return ModelValueEnum.getForPacKeyword(PropertyDefinitionType.class, text);
    }

    public static PropertyDefinitionType getForJsonKeyword(String text) {
        return ModelValueEnum.getForJsonKeyword(PropertyDefinitionType.class, text);
    }
}

