/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import ucd.pacc.model.AbstractPropertyDefinitionOptions;
import ucd.pacc.model.MultiValuedPropertyDefinitionOptions;
import ucd.pacc.model.PropertyDefinition;
import ucd.pacc.model.PropertyDefinitionType;
import ucd.pacc.model.SelectPropertyValue;
import ucd.pacc.model.Step;
import ucd.pacc.model.Stringish;
import ucd.pacc.parser.ParseException;

public class SelectPropertyDefinitionOptions
extends AbstractPropertyDefinitionOptions
implements MultiValuedPropertyDefinitionOptions {
    private final List<SelectPropertyValue> values = new ArrayList<SelectPropertyValue>();
    private Optional<SelectPropertyValue> defaultValue = Optional.empty();

    @Override
    public void addValue(SelectPropertyValue value) {
        value.getClass();
        this.values.add(value);
    }

    @Override
    public List<SelectPropertyValue> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public Optional<SelectPropertyValue> getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Optional<SelectPropertyValue> defaultValue) {
        defaultValue.ifPresent(value -> {
            if (!this.values.contains(value)) {
                this.addValue((SelectPropertyValue)value);
            }
        });
        this.defaultValue = defaultValue;
    }

    @Override
    public PropertyDefinitionType getType() {
        return PropertyDefinitionType.SELECT;
    }

    @Override
    public void checkDefaultAgainstPattern(Step step, PropertyDefinition propertyDefinition) throws ParseException {
        this.checkDefaultValueAgainstPattern(step, propertyDefinition, this.getDefaultValue().map(Stringish::getValue));
    }
}

