/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.analysis;

import java.util.HashSet;
import java.util.Optional;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.PropertyDefinition;
import ucd.pacc.model.PropertyDefinitionContainer;
import ucd.pacc.model.PropertyName;
import ucd.pacc.model.Step;
import ucd.pacc.parser.NonUniquePropertyDefinitionNameException;
import ucd.pacc.parser.ParseException;
import ucd.pacc.util.StepGraphProcessor;

public class CheckPropertyDefinitionNameUniquenessProcessor
extends StepGraphProcessor<CheckPropertyDefinitionNameUniquenessProcessor> {
    @Override
    protected CheckPropertyDefinitionNameUniquenessProcessor createNestedInstance() {
        return new CheckPropertyDefinitionNameUniquenessProcessor();
    }

    @Override
    protected void processStep(Step step) throws ParseException {
        if (step instanceof PropertyDefinitionContainer) {
            this.checkPropertyDefinitionNameUniqueness(step, (PropertyDefinitionContainer)((Object)step));
        }
    }

    protected void checkPropertyDefinitionNameUniqueness(Step step, PropertyDefinitionContainer container) throws ParseException {
        HashSet<PropertyName> names = new HashSet<PropertyName>();
        for (PropertyDefinition propdef : container.getPropertyDefinitions()) {
            PropertyName name = propdef.getName();
            if (names.add(name)) continue;
            ParseSourcePosition position = propdef.getPosition().orElse(step.getPosition());
            throw new NonUniquePropertyDefinitionNameException(Optional.of(position), String.format("non-unique property definition name: step=%s propdef=%s", step.getName().quote(), name.quote()));
        }
    }
}

