/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.analysis;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import ucd.pacc.model.Step;
import ucd.pacc.model.StepName;
import ucd.pacc.parser.NonUniqueStepNameException;
import ucd.pacc.parser.ParseException;
import ucd.pacc.util.StepGraphProcessor;

public class CheckStepNameUniquenessProcessor
extends StepGraphProcessor<CheckStepNameUniquenessProcessor> {
    private final Set<StepName> names = new HashSet<StepName>();

    @Override
    protected CheckStepNameUniquenessProcessor createNestedInstance() {
        return new CheckStepNameUniquenessProcessor();
    }

    @Override
    protected void processStep(Step step) throws ParseException {
        this.checkName(step);
    }

    protected void checkName(Step step) throws ParseException {
        StepName name = step.getName();
        if (!this.names.add(name)) {
            throw new NonUniqueStepNameException(Optional.of(step.getPosition()), "non-unique step name: name=" + name.quote());
        }
    }
}

