/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.json;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import ucd.pacc.model.ComponentTagName;
import ucd.pacc.model.Concurrency;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.PreconditionScript;
import ucd.pacc.model.Property;
import ucd.pacc.model.PropertyExpression;
import ucd.pacc.model.PropertyName;
import ucd.pacc.model.ResourceTagName;
import ucd.pacc.model.Step;
import ucd.pacc.model.StepName;
import ucd.pacc.parser.SyntaxException;
import ucd.pacc.util.JsonUtil;
import ucd.pacc.util.ParseExceptionCarrierException;
import ucd.pacc.util.StringParser;
import ucd.pacc.util.Util;

abstract class StepExtractor<T extends Step> {
    static final Pattern KEY_PATTERN = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*");
    static final Pattern PATH_PATTERN = Pattern.compile("\\$(\\..*)?(?<!\\.)");
    static final JsonPath BASE = new JsonPath("$");
    protected final ParseSourcePosition position;
    protected final JsonObject object;
    protected final String context;
    protected final JsonUtil jsonUtil;

    protected StepExtractor(ParseSourcePosition position, JsonObject object, String context, JsonUtil jsonUtil) {
        this.position = position;
        this.position.getClass();
        this.object = object;
        this.object.getClass();
        this.context = context;
        this.context.getClass();
        this.jsonUtil = jsonUtil;
        this.jsonUtil.getClass();
    }

    public abstract T extract();

    protected StepName getStepName() {
        return this.getAnchor();
    }

    protected StepName getAnchor() {
        return this.parse(StepName::new, this.mustGetString("name"));
    }

    protected Optional<String> findString(JsonKey key, JsonPath path) {
        return this.findInstanceOfType(key, path, String.class);
    }

    protected Optional<Boolean> findBoolean(JsonKey key, JsonPath path) {
        return this.findInstanceOfType(key, path, Boolean.class);
    }

    protected Optional<JsonObject> findJsonObject(JsonKey key, JsonPath path) {
        return this.findInstanceOfType(key, path, JsonObject.class);
    }

    protected Optional<JsonObject> findJsonObjectNode(JsonPath path) {
        return this.analyzeFindings(this.jsonUtil.find((JsonStructure)this.object, path.path), "NONE", JsonObject.class);
    }

    protected JsonObject mustFindJsonObjectNode(JsonPath path) {
        return this.findJsonObjectNode(path).orElseThrow(() -> this.createSyntaxExceptionCarrier("cannot find path '" + path + "' in " + this.context));
    }

    protected <U> Optional<U> findInstanceOfType(JsonKey key, JsonPath path, Class<U> targetType) {
        return this.analyzeFindings(this.jsonUtil.find((JsonStructure)this.object, path.append((JsonKey)key).path), key.key, targetType);
    }

    protected String mustFindString(JsonKey key, JsonPath path) {
        return this.mustFindInstanceOfType(key, path, String.class);
    }

    protected JsonObject mustFindJsonObject(JsonKey key, JsonPath path) {
        return this.mustFindInstanceOfType(key, path, JsonObject.class);
    }

    private <U> U mustFindInstanceOfType(JsonKey key, JsonPath path, Class<U> targetType) {
        return this.findInstanceOfType(key, path, targetType).orElseThrow(() -> this.createSyntaxExceptionCarrier("missing field '" + key + "' in " + this.context));
    }

    private <U> Optional<U> analyzeFindings(Object findings, String key, Class<U> targetType) {
        if (findings instanceof JsonArray) {
            JsonArray array = (JsonArray)findings;
            int size = array.size();
            if (size == 0) {
                return Optional.empty();
            }
            if (size == 1) {
                JsonValue value = (JsonValue)array.get(0);
                if (value == null || value == JsonValue.NULL) {
                    return Optional.empty();
                }
                if (targetType.isInstance(value)) {
                    return Optional.of(targetType.cast(value));
                }
                if (value instanceof JsonString && targetType == String.class) {
                    String string = ((JsonString)value).getString();
                    if (string == null) {
                        return Optional.empty();
                    }
                    return Optional.of(targetType.cast(string));
                }
                if (value == JsonValue.TRUE && (targetType == Boolean.class || targetType == Boolean.TYPE)) {
                    return Optional.of(targetType.cast(true));
                }
                if (value == JsonValue.FALSE && (targetType == Boolean.class || targetType == Boolean.TYPE)) {
                    return Optional.of(targetType.cast(false));
                }
                throw new RuntimeException(String.format("unhandled type conversion: target=%s actual=%s", targetType.getName(), value.getClass().getName()));
            }
            throw this.createSyntaxExceptionCarrier("non-unique field '" + key + "' in " + this.context);
        }
        if (targetType.isInstance(findings)) {
            return Optional.of(targetType.cast(findings));
        }
        if (findings != null) {
            throw this.createSyntaxExceptionCarrier("invalid value in field '" + key + "' in " + this.context);
        }
        return Optional.empty();
    }

    protected String mustGetString(String key) {
        Optional<JsonString> jsonString = Optional.ofNullable(this.object.getJsonString(key));
        String string = this.mustGet(jsonString.map(JsonString::getString), key);
        if (string.isEmpty()) {
            throw this.createSyntaxExceptionCarrier("blank field '" + key + "' in " + this.context);
        }
        return string;
    }

    protected <U> U mustGet(Optional<U> opt, String key) {
        return opt.orElseThrow(() -> this.createSyntaxExceptionCarrier("missing field '" + key + "' in " + this.context));
    }

    protected ParseExceptionCarrierException createSyntaxExceptionCarrier(String message) {
        return new ParseExceptionCarrierException(new SyntaxException(Optional.empty(), message));
    }

    protected Stream<Property> findProperties() {
        JsonObject properties = this.object.getJsonObject("properties");
        if (properties == null) {
            return Stream.empty();
        }
        return properties.entrySet().stream().map(this::extractProperty);
    }

    protected String findPostProcessingScriptName() {
        if (this.object.containsKey((Object)"postProcessingScript")) {
            return this.object.getString("postProcessingScript", null);
        }
        return "";
    }

    protected Optional<Boolean> getFailFast() {
        return this.findBoolean(new JsonKey("failFast"), BASE);
    }

    protected Optional<Boolean> getIgnoreChildWarnings() {
        return this.findBoolean(new JsonKey("isIgnoreChildWarnings"), BASE);
    }

    protected Optional<Boolean> getRunOnFirstOnlineResourceOnly() {
        return this.findBoolean(new JsonKey("runOnlyOnFirst"), BASE);
    }

    protected Optional<PreconditionScript> getPreconditionScript() {
        return this.findString(new JsonKey("preconditionScript"), BASE).filter(Util::isNotEmpty).map(this.createParser(PreconditionScript::new));
    }

    protected Optional<Concurrency> getMaxConcurrentProcesses() {
        return this.findString(new JsonKey("maxIteration"), BASE).map(this.createParser(Concurrency::createFromJsonString));
    }

    protected Optional<Concurrency> getMaxConcurrentComponents() {
        return this.findString(new JsonKey("maxCompIteration"), BASE).map(this.createParser(Concurrency::createFromJsonString));
    }

    protected Optional<ComponentTagName> getByComponentTag() {
        return this.findString(new JsonKey("componentTagId"), BASE).filter(Util::isNotEmpty).map(this.createParser(ComponentTagName::new));
    }

    protected Optional<ResourceTagName> getByResourceTag() {
        return this.findString(new JsonKey("tagId"), BASE).filter(Util::isNotEmpty).map(this.createParser(ResourceTagName::new));
    }

    protected Property extractProperty(Map.Entry<String, JsonValue> entry) {
        String key = entry.getKey();
        JsonValue value = entry.getValue();
        if (value instanceof JsonString) {
            JsonString jsonString = (JsonString)value;
            return new Property(this.parse(PropertyName::new, key), this.parse(PropertyExpression::new, jsonString.getString()));
        }
        throw this.createSyntaxExceptionCarrier("bad property value for '" + key + "' in " + this.context);
    }

    protected <U> U parse(Function<String, U> ctor, String value) {
        return this.createParser(ctor).apply(value);
    }

    protected <U> Function<String, U> createParser(Function<String, U> ctor) {
        return value -> StringParser.parseWithExceptionCarrier(this.position, ctor, value);
    }

    protected void checkIsJsonString(String key, JsonValue value) {
        if (value == null || value.getValueType() != JsonValue.ValueType.STRING) {
            throw this.createSyntaxExceptionCarrier("unparseable value in field '" + key + "' in " + this.context);
        }
    }

    protected Stream<String> splitOnCommas(String string) {
        return Arrays.stream(string.split(",")).filter(Util::isNotEmpty);
    }

    protected static final class JsonPath {
        final String path;

        JsonPath(String path) {
            this.path = path;
            this.path.getClass();
            if (!PATH_PATTERN.matcher(path).matches()) {
                throw new IllegalArgumentException("bad path: " + path);
            }
        }

        JsonPath append(JsonKey key) {
            return new JsonPath(this.path + "." + key.key);
        }

        public String toString() {
            return this.path;
        }
    }

    protected static final class JsonKey {
        final String key;

        JsonKey(String key) {
            this.key = key;
            this.key.getClass();
            if (!KEY_PATTERN.matcher(key).matches()) {
                throw new IllegalArgumentException("bad key: " + key);
            }
        }

        public String toString() {
            return this.key;
        }
    }
}

