/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.json;

import java.util.Optional;
import javax.json.JsonObject;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.PluginCommandName;
import ucd.pacc.model.PluginName;
import ucd.pacc.model.PluginStep;
import ucd.pacc.model.WorkingDirectory;
import ucd.pacc.parser.json.StepExtractor;
import ucd.pacc.util.JsonUtil;
import ucd.pacc.util.Util;

class StepExtractorPlugin
extends StepExtractor<PluginStep> {
    StepExtractorPlugin(ParseSourcePosition position, JsonObject object, JsonUtil jsonUtil) {
        super(position, object, "plugin step", jsonUtil);
    }

    @Override
    public PluginStep extract() {
        PluginStep step = new PluginStep(this.position, this.getStepName(), this.getPluginName(), this.getPluginCommandName());
        step.setPreconditionScript(this.getPreconditionScript());
        step.setWorkingDirectory(this.getWorkingDirectory());
        this.findProperties().forEach(step::addProperty);
        step.setPostProcessingPropertyName(this.findPostProcessingScriptName());
        return step;
    }

    private PluginName getPluginName() {
        return this.parse(PluginName::new, this.mustGetString("pluginName"));
    }

    private PluginCommandName getPluginCommandName() {
        return this.parse(PluginCommandName::new, this.mustGetString("commandName"));
    }

    private Optional<WorkingDirectory> getWorkingDirectory() {
        return this.findString(new StepExtractor.JsonKey("workingDir"), BASE).filter(Util::isNotEmpty).map(this.createParser(WorkingDirectory::new));
    }
}

