/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.util;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import ucd.pacc.util.ErrorHandler;
import ucd.pacc.util.Util;

public class JsonUtil {
    private final WeakHashMap<JsonValue, Object> parsedJsonCache = new WeakHashMap();
    private final JsonProvider jsonProvider = JsonProvider.provider();
    private final com.jayway.jsonpath.spi.json.JsonProvider jsonPathProvider;
    private final ParseContext jsonPathContext;

    public JsonUtil() {
        Configuration conf = Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
        this.jsonPathProvider = conf.jsonProvider();
        this.jsonPathContext = JsonPath.using((Configuration)conf);
    }

    public JsonObject readJsonObject(String json) {
        return this.jsonProvider.createReader((Reader)new StringReader(json)).readObject();
    }

    public <T> T find(JsonStructure root, String path) {
        return this.translate(this.read(root, path));
    }

    public <T> Optional<T> findUnique(JsonStructure root, String path) {
        return Optional.ofNullable(this.translate(this.getSingleton(this.read(root, path))));
    }

    public <T> Optional<T> findUnique(JsonStructure root, String path, Class<T> klass) {
        return this.findUnique(root, path).flatMap(Util.asInstanceofOptional(klass));
    }

    public <T> T mustFindUnique(JsonStructure root, String path) {
        Optional<T> opt = this.findUnique(root, path);
        if (!opt.isPresent()) {
            throw new RuntimeException("unique path not found: " + path);
        }
        return opt.get();
    }

    private Object read(JsonStructure root, String path) {
        return this.jsonPathContext.parse(this.getParsedJson((JsonValue)root)).read(path, new Predicate[0]);
    }

    private Object getParsedJson(JsonValue value) {
        value.getClass();
        Object parsedJson = this.parsedJsonCache.get(value);
        if (parsedJson == null) {
            parsedJson = this.parse(value);
            this.parsedJsonCache.put(value, parsedJson);
        }
        return parsedJson;
    }

    private Object parse(JsonValue value) {
        return this.jsonPathProvider.parse(value.toString());
    }

    private <T> T getSingleton(Object object) {
        if (object instanceof Collection) {
            Collection list = (Collection)object;
            Iterator iterator = list.iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            Object result = iterator.next();
            if (iterator.hasNext()) {
                ErrorHandler.printErrorAndExit("This process has multiple finish steps.\n Currently PAAC doesn't support the scenario.\n Please modify the process in the UI");
            }
            return (T)result;
        }
        return (T)object;
    }

    private <T, I> T translate(I input) {
        switch (this.typeOf(input)) {
            case NULL: 
            case STRING: 
            case BOOLEAN: 
            case CHARACTER: 
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BIGINTEGER: 
            case BIGDECIMAL: 
            case JSONVALUE: {
                return (T)input;
            }
            case LIST: {
                return (T)this.translateList((List)input);
            }
            case MAP: {
                return (T)this.translateMap((Map)input);
            }
            case COLLECTION: {
                return (T)this.translateCollection((Collection)input);
            }
        }
        throw new RuntimeException("unimplemented type: " + input.getClass().getName());
    }

    private JsonArray translateList(List<?> input) {
        if (input == null) {
            return null;
        }
        if (input instanceof JsonArray) {
            return (JsonArray)input;
        }
        JsonArrayBuilder builder = this.jsonProvider.createArrayBuilder();
        block18: for (Object val : input) {
            switch (this.typeOf(val)) {
                case NULL: {
                    builder.addNull();
                    continue block18;
                }
                case STRING: {
                    builder.add(val.toString());
                    continue block18;
                }
                case BOOLEAN: {
                    builder.add(((Boolean)val).booleanValue());
                    continue block18;
                }
                case CHARACTER: {
                    builder.add(val.toString());
                    continue block18;
                }
                case BYTE: {
                    builder.add((int)((Byte)val).byteValue());
                    continue block18;
                }
                case SHORT: {
                    builder.add((int)((Short)val).shortValue());
                    continue block18;
                }
                case INTEGER: {
                    builder.add(((Integer)val).intValue());
                    continue block18;
                }
                case LONG: {
                    builder.add(((Long)val).longValue());
                    continue block18;
                }
                case FLOAT: {
                    builder.add((double)((Float)val).floatValue());
                    continue block18;
                }
                case DOUBLE: {
                    builder.add(((Double)val).doubleValue());
                    continue block18;
                }
                case BIGINTEGER: {
                    builder.add((BigInteger)val);
                    continue block18;
                }
                case BIGDECIMAL: {
                    builder.add((BigDecimal)val);
                    continue block18;
                }
                case JSONVALUE: {
                    builder.add((JsonValue)val);
                    continue block18;
                }
                case LIST: {
                    builder.add((JsonValue)this.translateList((List)val));
                    continue block18;
                }
                case MAP: {
                    builder.add((JsonValue)this.translateMap((Map)val));
                    continue block18;
                }
                case COLLECTION: {
                    builder.add((JsonValue)this.translateCollection((Collection)val));
                    continue block18;
                }
            }
            throw new RuntimeException("unimplemented type: " + input.getClass().getName());
        }
        return builder.build();
    }

    private JsonObject translateMap(Map<?, ?> input) {
        if (input == null) {
            return null;
        }
        if (input instanceof JsonObject) {
            return (JsonObject)input;
        }
        JsonObjectBuilder builder = this.jsonProvider.createObjectBuilder();
        input.forEach((keyobj, val) -> {
            String key = (String)keyobj;
            switch (this.typeOf(val)) {
                case NULL: {
                    builder.addNull(key);
                    break;
                }
                case STRING: {
                    builder.add(key, val.toString());
                    break;
                }
                case BOOLEAN: {
                    builder.add(key, ((Boolean)val).booleanValue());
                    break;
                }
                case CHARACTER: {
                    builder.add(key, val.toString());
                    break;
                }
                case BYTE: {
                    builder.add(key, (int)((Byte)val).byteValue());
                    break;
                }
                case SHORT: {
                    builder.add(key, (int)((Short)val).shortValue());
                    break;
                }
                case INTEGER: {
                    builder.add(key, ((Integer)val).intValue());
                    break;
                }
                case LONG: {
                    builder.add(key, ((Long)val).longValue());
                    break;
                }
                case FLOAT: {
                    builder.add(key, (double)((Float)val).floatValue());
                    break;
                }
                case DOUBLE: {
                    builder.add(key, ((Double)val).doubleValue());
                    break;
                }
                case BIGINTEGER: {
                    builder.add(key, (BigInteger)val);
                    break;
                }
                case BIGDECIMAL: {
                    builder.add(key, (BigDecimal)val);
                    break;
                }
                case JSONVALUE: {
                    builder.add(key, (JsonValue)val);
                    break;
                }
                case LIST: {
                    builder.add(key, (JsonValue)this.translateList((List)val));
                    break;
                }
                case MAP: {
                    builder.add(key, (JsonValue)this.translateMap((Map)val));
                    break;
                }
                case COLLECTION: {
                    builder.add(key, (JsonValue)this.translateCollection((Collection)val));
                    break;
                }
                default: {
                    throw new RuntimeException("unimplemented type: " + input.getClass().getName());
                }
            }
        });
        return builder.build();
    }

    private JsonArray translateCollection(Collection<?> input) {
        return this.translateList(new ArrayList(input));
    }

    private Type typeOf(Object obj) {
        if (obj == null) {
            return Type.NULL;
        }
        if (obj instanceof String) {
            return Type.STRING;
        }
        if (obj instanceof Boolean) {
            return Type.BOOLEAN;
        }
        if (obj instanceof Character) {
            return Type.CHARACTER;
        }
        if (obj instanceof Byte) {
            return Type.BYTE;
        }
        if (obj instanceof Short) {
            return Type.SHORT;
        }
        if (obj instanceof Integer) {
            return Type.INTEGER;
        }
        if (obj instanceof Long) {
            return Type.LONG;
        }
        if (obj instanceof Float) {
            return Type.FLOAT;
        }
        if (obj instanceof Double) {
            return Type.DOUBLE;
        }
        if (obj instanceof BigInteger) {
            return Type.BIGINTEGER;
        }
        if (obj instanceof BigDecimal) {
            return Type.BIGDECIMAL;
        }
        if (obj instanceof JsonValue) {
            return Type.JSONVALUE;
        }
        if (obj instanceof List) {
            return Type.LIST;
        }
        if (obj instanceof Map) {
            return Type.MAP;
        }
        if (obj instanceof Collection) {
            return Type.COLLECTION;
        }
        throw new RuntimeException("unimplemented type: " + obj.getClass().getName());
    }

    private static enum Type {
        NULL,
        STRING,
        BOOLEAN,
        CHARACTER,
        BYTE,
        SHORT,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        BIGINTEGER,
        BIGDECIMAL,
        JSONVALUE,
        LIST,
        MAP,
        COLLECTION;

    }
}

