/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.util;

import ucd.pacc.model.Step;
import ucd.pacc.model.StepGraph;
import ucd.pacc.model.StepGraphContainer;
import ucd.pacc.parser.ParseException;

public abstract class StepGraphProcessor<T extends StepGraphProcessor<T>> {
    boolean executed;

    protected StepGraphProcessor() {
    }

    public void process(StepGraph graph) throws ParseException {
        this.checkNotExecuted();
        this.processStepGraph(graph);
        this.setExecuted(true);
    }

    protected boolean isExecuted() {
        return this.executed;
    }

    protected void setExecuted(boolean executed) {
        this.executed = executed;
    }

    protected void checkNotExecuted() {
        if (this.isExecuted()) {
            throw new IllegalStateException("processor already executed: processor=" + this.getClass().getName());
        }
    }

    protected void checkExecuted() {
        if (!this.isExecuted()) {
            throw new IllegalStateException("processor not executed: processor=" + this.getClass().getName());
        }
    }

    protected void processStepStart(Step step) throws ParseException {
    }

    protected abstract void processStep(Step var1) throws ParseException;

    protected void processStepEnd(Step step) throws ParseException {
    }

    protected void processStepGraph(StepGraph graph) throws ParseException {
        this.processStepGraphStart(graph);
        this.processStepGraphSteps(graph);
        this.processStepGraphEnd(graph);
    }

    protected void processStepGraphStart(StepGraph graph) throws ParseException {
    }

    protected void processStepGraphSteps(StepGraph graph) throws ParseException {
        for (Step step : graph.getSteps()) {
            this.processStepStart(step);
            this.processStep(step);
            if (step instanceof StepGraphContainer) {
                this.processStepAsStepGraphContainer((StepGraphContainer)((Object)step));
            }
            this.processStepEnd(step);
        }
    }

    protected void processStepGraphEnd(StepGraph graph) throws ParseException {
    }

    protected abstract T createNestedInstance() throws ParseException;

    protected void processStepAsStepGraphContainer(StepGraphContainer container) throws ParseException {
        T nestedInstance = this.createNestedInstance();
        this.processStepGraphContainerStart(nestedInstance, container);
        this.processStepGraphContainer(nestedInstance, container);
        this.processStepGraphContainerEnd(nestedInstance, container);
    }

    protected void processStepGraphContainerStart(T nestedInstance, StepGraphContainer container) throws ParseException {
    }

    protected void processStepGraphContainer(T nestedInstance, StepGraphContainer container) throws ParseException {
        ((StepGraphProcessor)nestedInstance).processStepGraph(container.getGraph());
    }

    protected void processStepGraphContainerEnd(T nestedInstance, StepGraphContainer container) throws ParseException {
    }
}

