/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucd.pacc.model.ParseSourcePosition;

class TripleUnquoter {
    private static final String TQ = "\"\"\"";
    private static final String DTQ = "\"\"\"\"\"\"";
    private static final Pattern LINE_WITH_EOL = Pattern.compile("[^\n\r]*(\r\n|\n|\r)");
    private final String text;
    private final int indent;

    TripleUnquoter(String text, ParseSourcePosition position) {
        this.text = text;
        this.text.getClass();
        this.indent = position.getColumn() - 1;
    }

    public String unquote() {
        return this.unindent(this.unescapeQuotes(this.stripOuterQuotes(this.text)));
    }

    private String stripOuterQuotes(String s) {
        return this.text.substring(TQ.length(), this.text.length() - TQ.length());
    }

    private String unescapeQuotes(String s) {
        return s.replace(DTQ, TQ);
    }

    private String unindent(String s) {
        List<String> lines = this.splitLines(s);
        if (lines.size() > 1 && this.isBlankLine(lines.get(0))) {
            lines.remove(0);
        }
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(this.trimIndent(line));
        }
        return sb.toString();
    }

    private List<String> splitLines(String s) {
        ArrayList<String> lines = new ArrayList<String>();
        Matcher m = LINE_WITH_EOL.matcher(s);
        int start = 0;
        while (m.find(start)) {
            int end = m.end();
            lines.add(s.substring(start, end));
            start = end;
        }
        if (start != s.length()) {
            lines.add(s.substring(start));
        }
        return lines;
    }

    private String trimIndent(String s) {
        int start;
        int end = s.length();
        for (start = 0; start < this.indent && start < end && this.isWhitespace(s.charAt(start)); ++start) {
        }
        return s.substring(start, end);
    }

    private boolean isWhitespace(int c) {
        return c == 32 || c == 9;
    }

    private boolean isEol(int c) {
        return c == 10 || c == 13;
    }

    private boolean isBlankLine(String s) {
        return s.chars().allMatch(c -> this.isWhitespace(c) || this.isEol(c));
    }
}

